/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.data.menu.Input;

import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.weido.create_bb.data.menu.Entry.StyleEntry;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class VariantScrollInput
extends ScrollInput {
    private final MutableComponent scrollToSelect = Component.translatable((String)"create_bb.menu.scroll_selection");
    private final MutableComponent noOptionAvailable = Component.translatable((String)"create_bb.menu.no_options_available");
    public StyleEntry.Variant[] variants = StyleEntry.Variant.values();

    public VariantScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.withRange(0, this.variants.length).titled(Component.translatable((String)"create_bb.menu.variant")).format(index -> index >= this.variants.length ? Component.empty() : this.variants[index].getDisplayText()).inverted().setState(0);
        this.updateTooltip();
    }

    public void updateOptions(Set<StyleEntry.Variant> validVariants) {
        LinkedList<StyleEntry.Variant> sortedList = new LinkedList<StyleEntry.Variant>(validVariants);
        List<StyleEntry.Variant> priorityOrder = List.of(StyleEntry.Variant.LONG, StyleEntry.Variant.SHORT, StyleEntry.Variant.PISTONLESS, StyleEntry.Variant.STANDARD, StyleEntry.Variant.TRAILING);
        sortedList.sort(Comparator.comparingInt(priorityOrder::indexOf));
        this.variants = sortedList.toArray(new StyleEntry.Variant[0]);
        this.withRange(0, this.variants.length);
        if (this.state >= this.variants.length) {
            this.setState(0);
        }
        this.format(index -> index >= this.variants.length ? Component.empty() : this.variants[index].getDisplayText());
        this.updateTooltip();
    }

    protected void updateTooltip() {
        this.toolTip.clear();
        if (this.title != null) {
            this.toolTip.add(this.title.copy().withStyle(s -> s.withColor(HEADER_RGB.getRGB())));
        }
        for (int i = 0; i < this.variants.length; ++i) {
            MutableComponent variant = Component.empty().append(i == this.state ? "-> " : "> ").append(this.variants[i].getDisplayText());
            this.toolTip.add(variant.withStyle(i == this.state ? ChatFormatting.WHITE : ChatFormatting.GRAY));
        }
        if (this.variants.length == 1) {
            this.toolTip.add(this.noOptionAvailable.plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        } else {
            this.toolTip.add(this.scrollToSelect.plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
    }
}

