/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.bigsignwriter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import dev.chililisoup.bigsignwriter.BigSignWriter;
import dev.chililisoup.bigsignwriter.font.BuiltInFonts;
import dev.chililisoup.bigsignwriter.font.FontFile;
import dev.chililisoup.bigsignwriter.font.supplier.FontSupplier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.neoforged.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;

public class BigSignWriterConfig {
    public static FontFile SELECTED_FONT;
    public static String CHARACTER_SEPARATOR;
    public static List<FontFile> AVAILABLE_FONTS;
    public static FontFile DEFAULT_FONT;
    public static MainConfig MAIN_CONFIG;
    private static int SELECTED_FONT_INDEX;

    public static void noop() {
    }

    private static Path getConfigDir() {
        Path configDir = FMLPaths.CONFIGDIR.get().resolve("bigsignwriter");
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            BigSignWriter.LOGGER.error("Failed to create config directory: {}", (Object)configDir, (Object)e);
        }
        return configDir;
    }

    @NotNull
    private static Path getFontsDir() {
        Path fontsDir = BigSignWriterConfig.getConfigDir().resolve("fonts");
        try {
            Files.createDirectories(fontsDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            BigSignWriter.LOGGER.error("Failed to create fonts directory: {}", (Object)fontsDir, (Object)e);
        }
        return fontsDir;
    }

    public static void reloadFonts() {
        BigSignWriterConfig.copyBuiltInFonts();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Path fontsDir = BigSignWriterConfig.getFontsDir();
        File[] jsonFiles = fontsDir.toFile().listFiles((dir, name) -> name.endsWith(".json"));
        if (jsonFiles == null || jsonFiles.length == 0) {
            BigSignWriter.LOGGER.error("Failed to load or create any font files. Mod behavior from here is undefined. Please report!");
            return;
        }
        Arrays.sort(jsonFiles, (a, b) -> a.getName().compareToIgnoreCase(b.getName()));
        AVAILABLE_FONTS = Arrays.stream(jsonFiles).map(file -> BigSignWriterConfig.getFont(gson, file.toPath()).load()).toList();
        BigSignWriterConfig.selectFont(SELECTED_FONT_INDEX >= AVAILABLE_FONTS.size() ? 0 : SELECTED_FONT_INDEX);
        BigSignWriter.LOGGER.info("Fonts loaded!");
    }

    private static ConfigInterface<FontFile> getFont(Gson gson, Path path) {
        return new ConfigInterface<FontFile>(gson, new TypeToken<FontFile>(){}, path, new FontFile());
    }

    private static void copyBuiltInFonts() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Path configFonts = BigSignWriterConfig.getFontsDir();
        try {
            Files.createDirectories(configFonts, new FileAttribute[0]);
            BuiltInFonts.get().forEach((path, font) -> {
                FontFile fontDefaults = font.get();
                Path target = configFonts.resolve(path + ".json");
                ConfigInterface<FontFile> file = BigSignWriterConfig.getFont(gson, target);
                if (Files.notExists(target, new LinkOption[0])) {
                    file.save(fontDefaults);
                    BigSignWriter.LOGGER.info("Copied built-in font: {}", (Object)fontDefaults.name);
                    if (fontDefaults.name.equals("Default")) {
                        DEFAULT_FONT = fontDefaults;
                    }
                    return;
                }
                FontFile existingFont = file.load();
                Map<Character, Set<FontSupplier.PatchCharacter>> patches = font.patches();
                ArrayList<Character> changed = new ArrayList<Character>();
                ArrayList<Character> patched = new ArrayList<Character>();
                block0: for (char character : fontDefaults.characters.keySet()) {
                    if (existingFont.characters.containsKey(Character.valueOf(character))) {
                        if (!patches.containsKey(Character.valueOf(character))) continue;
                        String existing = String.join((CharSequence)"\n", existingFont.characters.get(Character.valueOf(character)));
                        for (FontSupplier.PatchCharacter patch : patches.get(Character.valueOf(character))) {
                            if (!String.join((CharSequence)"\n", patch.lines()).matches(existing)) continue;
                            existingFont.characters.put(Character.valueOf(character), fontDefaults.characters.get(Character.valueOf(character)));
                            patched.add(Character.valueOf(character));
                            continue block0;
                        }
                        continue;
                    }
                    existingFont.characters.put(Character.valueOf(character), fontDefaults.characters.get(Character.valueOf(character)));
                    changed.add(Character.valueOf(character));
                }
                if (!changed.isEmpty() || !patched.isEmpty()) {
                    file.save(existingFont);
                    if (!changed.isEmpty()) {
                        BigSignWriter.LOGGER.info("Merged new characters from built-in font '{}': {}", (Object)fontDefaults.name, changed);
                    }
                    if (!patched.isEmpty()) {
                        BigSignWriter.LOGGER.info("Patched outdated characters from built-in font '{}': {}", (Object)fontDefaults.name, patched);
                    }
                }
                if (existingFont.name.equals("Default")) {
                    DEFAULT_FONT = existingFont;
                }
            });
        }
        catch (Exception e) {
            BigSignWriter.LOGGER.error("Error copying built-in fonts", (Throwable)e);
        }
    }

    private static ConfigInterface<MainConfig> getConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Path configDir = BigSignWriterConfig.getConfigDir();
        return new ConfigInterface<MainConfig>(gson, TypeToken.get(MainConfig.class), configDir.resolve("config.json"), new MainConfig());
    }

    public static void saveConfig() {
        ConfigInterface<MainConfig> mainConfig = BigSignWriterConfig.getConfig();
        mainConfig.save(MAIN_CONFIG);
        BigSignWriterConfig.selectFont(SELECTED_FONT_INDEX);
        BigSignWriter.LOGGER.info("Config saved!");
    }

    public static void reloadConfig() {
        ConfigInterface<MainConfig> mainConfig = BigSignWriterConfig.getConfig();
        MAIN_CONFIG = mainConfig.load();
        mainConfig.save(MAIN_CONFIG);
        BigSignWriter.LOGGER.debug("Config loaded!");
    }

    private static void selectFont(int index) {
        SELECTED_FONT_INDEX = index % AVAILABLE_FONTS.size();
        SELECTED_FONT = AVAILABLE_FONTS.get(SELECTED_FONT_INDEX);
        CHARACTER_SEPARATOR = BigSignWriterConfig.SELECTED_FONT.characterSeparator == null ? BigSignWriterConfig.MAIN_CONFIG.defaultCharacterSeparator : BigSignWriterConfig.SELECTED_FONT.characterSeparator;
    }

    public static void getNextFont() {
        BigSignWriterConfig.selectFont(SELECTED_FONT_INDEX + 1);
        BigSignWriter.LOGGER.debug("Switched to font {} at index {}", (Object)BigSignWriterConfig.SELECTED_FONT.name, (Object)SELECTED_FONT_INDEX);
    }

    static {
        BigSignWriterConfig.reloadConfig();
        BigSignWriterConfig.reloadFonts();
    }

    private record ConfigInterface<T>(Gson gson, TypeToken<T> typeToken, Path path, T defaultConfig) {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T load() {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.path.toFile()), StandardCharsets.UTF_8);){
                JsonReader jsonReader = new JsonReader((Reader)reader);
                Object object = this.gson.fromJson(jsonReader, this.typeToken);
                return (T)object;
            }
            catch (FileNotFoundException e) {
                this.save(this.defaultConfig);
                return this.defaultConfig;
            }
            catch (Exception e) {
                BigSignWriter.LOGGER.error("Failed to load config: {}", (Object)this.path.getFileName(), (Object)e);
                return this.defaultConfig;
            }
        }

        public void save(T config) {
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.path.toFile()), StandardCharsets.UTF_8);){
                this.gson.toJson(config, (Appendable)writer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class MainConfig {
        public int buttonsX = 0;
        public int buttonsY = 120;
        public double buttonsAlignmentX = 0.5;
        public double buttonsAlignmentY = 0.25;
        public String defaultCharacterSeparator = " ";
    }
}

