/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.bigsignwriter.font.supplier;

import com.google.common.collect.ImmutableSet;
import dev.chililisoup.bigsignwriter.font.FontFile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public interface FontSupplier {
    public FontFile get();

    default public Map<Character, Set<PatchCharacter>> patches() {
        HashMap<Character, Set<PatchCharacter>> baseMap = new HashMap<Character, Set<PatchCharacter>>();
        this.appendRecolourfulContainersGuiFix(baseMap);
        return baseMap;
    }

    default public void appendRecolourfulContainersGuiFix(HashMap<Character, Set<PatchCharacter>> baseMap) {
        this.get().characters.forEach((character, lines) -> {
            if (!String.join((CharSequence)"", lines).contains("\u00a0")) {
                return;
            }
            baseMap.merge((Character)character, Set.of(PatchCharacter.of((String[])Arrays.stream(lines).map(line -> line.replace('\u00a0', '\u2009')).toArray(String[]::new))), (baseSet, fixSet) -> {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                builder.add((Object[])((PatchCharacter[])baseSet.toArray(PatchCharacter[]::new)));
                builder.add((Object[])((PatchCharacter[])fixSet.toArray(PatchCharacter[]::new)));
                return builder.build();
            });
        });
    }

    public record PatchCharacter(String[] lines) {
        static PatchCharacter of(String ... lines) {
            return new PatchCharacter(lines);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof PatchCharacter)) {
                return false;
            }
            PatchCharacter otherCharacter = (PatchCharacter)other;
            if (otherCharacter.lines.length != this.lines.length) {
                return false;
            }
            for (int i = 0; i < this.lines.length; ++i) {
                if (this.lines[i].equals(otherCharacter.lines[i])) continue;
                return false;
            }
            return true;
        }
    }
}

