/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.bigsignwriter.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import dev.chililisoup.bigsignwriter.BigSignWriter;
import dev.chililisoup.bigsignwriter.BigSignWriterConfig;
import dev.chililisoup.bigsignwriter.ClickableButtonWidget;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractSignEditScreen.class}, priority=999)
public abstract class AbstractSignEditScreenMixin
extends Screen {
    @Shadow
    @Final
    private SignBlockEntity sign;
    @Shadow
    @Final
    private String[] messages;
    @Shadow
    private int line;
    @Shadow
    @Nullable
    private TextFieldHelper signField;

    protected AbstractSignEditScreenMixin(Component title) {
        super(title);
    }

    @Unique
    private static Component bigSignWriter$createToggleButtonText() {
        return CommonComponents.optionStatus((Component)Component.translatableWithFallback((String)"bigsignwriter.enabled", (String)"Big Text"), (boolean)BigSignWriter.ENABLED);
    }

    @Unique
    private static Component bigSignWriter$createFontButtonText() {
        String fontName = BigSignWriterConfig.SELECTED_FONT == null || BigSignWriterConfig.SELECTED_FONT.name == null ? "Unknown" : BigSignWriterConfig.SELECTED_FONT.name;
        return CommonComponents.optionNameValue((Component)Component.translatableWithFallback((String)"bigsignwriter.font", (String)"Font"), (Component)Component.literal((String)fontName));
    }

    @Unique
    private static Optional<String[]> bigSignWriter$getBigChar(char chr) {
        if (BigSignWriterConfig.SELECTED_FONT == null) {
            return Optional.empty();
        }
        if (BigSignWriterConfig.SELECTED_FONT.characters == null) {
            return Optional.empty();
        }
        if (BigSignWriterConfig.SELECTED_FONT.characters.containsKey(Character.valueOf(chr))) {
            return Optional.of(BigSignWriterConfig.SELECTED_FONT.characters.get(Character.valueOf(chr)));
        }
        char upper = Character.toUpperCase(chr);
        if (BigSignWriterConfig.SELECTED_FONT.characters.containsKey(Character.valueOf(upper))) {
            return Optional.of(BigSignWriterConfig.SELECTED_FONT.characters.get(Character.valueOf(upper)));
        }
        if (BigSignWriterConfig.DEFAULT_FONT == null || BigSignWriterConfig.SELECTED_FONT.name.equals("Default")) {
            return Optional.empty();
        }
        if (BigSignWriterConfig.DEFAULT_FONT.characters.containsKey(Character.valueOf(chr))) {
            return Optional.of(BigSignWriterConfig.DEFAULT_FONT.characters.get(Character.valueOf(chr)));
        }
        if (BigSignWriterConfig.DEFAULT_FONT.characters.containsKey(Character.valueOf(upper))) {
            return Optional.of(BigSignWriterConfig.DEFAULT_FONT.characters.get(Character.valueOf(upper)));
        }
        return Optional.empty();
    }

    @Unique
    private void bigSignWriter$clearSign() {
        int i = 0;
        while (i < this.messages.length) {
            this.line = i++;
            this.setMessage("");
        }
        if (this.signField != null) {
            this.signField.setCursorToEnd();
        }
    }

    @Shadow
    private void setMessage(String string) {
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    private void addButtons(CallbackInfo ci) {
        ClickableButtonWidget toggleButton = new ClickableButtonWidget((int)((double)this.width * BigSignWriterConfig.MAIN_CONFIG.buttonsAlignmentX + (double)BigSignWriterConfig.MAIN_CONFIG.buttonsX - 100.0), (int)((double)this.height * BigSignWriterConfig.MAIN_CONFIG.buttonsAlignmentY + (double)BigSignWriterConfig.MAIN_CONFIG.buttonsY), 75, 20, AbstractSignEditScreenMixin.bigSignWriter$createToggleButtonText(), button -> {
            BigSignWriter.toggleEnabled();
            button.setMessage(AbstractSignEditScreenMixin.bigSignWriter$createToggleButtonText());
        });
        ClickableButtonWidget fontButton = new ClickableButtonWidget((int)((double)this.width * BigSignWriterConfig.MAIN_CONFIG.buttonsAlignmentX + (double)BigSignWriterConfig.MAIN_CONFIG.buttonsX - 25.0), (int)((double)this.height * BigSignWriterConfig.MAIN_CONFIG.buttonsAlignmentY + (double)BigSignWriterConfig.MAIN_CONFIG.buttonsY), 80, 20, AbstractSignEditScreenMixin.bigSignWriter$createFontButtonText(), button -> {
            BigSignWriterConfig.getNextFont();
            button.setMessage(AbstractSignEditScreenMixin.bigSignWriter$createFontButtonText());
        });
        ClickableButtonWidget reloadButton = new ClickableButtonWidget((int)((double)this.width * BigSignWriterConfig.MAIN_CONFIG.buttonsAlignmentX + (double)BigSignWriterConfig.MAIN_CONFIG.buttonsX + 55.0), (int)((double)this.height * BigSignWriterConfig.MAIN_CONFIG.buttonsAlignmentY + (double)BigSignWriterConfig.MAIN_CONFIG.buttonsY), 45, 20, (Component)Component.translatableWithFallback((String)"bigsignwriter.reload", (String)"Reload"), button -> {
            BigSignWriterConfig.reloadConfig();
            BigSignWriterConfig.reloadFonts();
            fontButton.setMessage(AbstractSignEditScreenMixin.bigSignWriter$createFontButtonText());
        });
        this.addRenderableWidget((GuiEventListener)toggleButton);
        this.addRenderableWidget((GuiEventListener)fontButton);
        this.addRenderableWidget((GuiEventListener)reloadButton);
    }

    @Inject(method={"charTyped"}, at={@At(value="HEAD")}, cancellable=true)
    private void charTypedInject(char chr, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!BigSignWriter.ENABLED) {
            return;
        }
        cir.setReturnValue((Object)true);
        String[] bigChar = AbstractSignEditScreenMixin.bigSignWriter$getBigChar(chr).orElse(new String[0]);
        if (bigChar.length == 0) {
            return;
        }
        for (int i = 0; i < this.messages.length; ++i) {
            if (i >= bigChar.length || bigChar[i] == null) continue;
            String string = this.messages[i].concat((this.messages[i].isEmpty() ? "" : BigSignWriterConfig.CHARACTER_SEPARATOR).concat(bigChar[i]));
            if (this.font.width(string) > this.sign.getMaxTextLineWidth()) continue;
            this.line = i;
            this.setMessage(string);
        }
        if (this.signField != null) {
            this.signField.setCursorToEnd();
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void deleteChar(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!BigSignWriter.ENABLED) {
            return;
        }
        if (keyCode != 259) {
            return;
        }
        cir.setReturnValue((Object)true);
        if (Screen.hasControlDown() || BigSignWriterConfig.CHARACTER_SEPARATOR.isEmpty()) {
            this.bigSignWriter$clearSign();
            return;
        }
        int firstWidth = this.font.width(this.messages[0]);
        for (int i = 1; i < this.messages.length; ++i) {
            if (firstWidth == this.font.width(this.messages[i])) continue;
            this.bigSignWriter$clearSign();
            return;
        }
        List<HashMap> separatorIndices = Arrays.stream(this.messages).map(message -> {
            HashMap<Integer, Integer> indices = new HashMap<Integer, Integer>();
            int index = message.indexOf(BigSignWriterConfig.CHARACTER_SEPARATOR);
            while (index >= 0) {
                indices.put(this.font.width(message.substring(index)), index);
                index = message.indexOf(BigSignWriterConfig.CHARACTER_SEPARATOR, index + 1);
            }
            return indices;
        }).toList();
        List<Integer> matchingSeparatorLengths = separatorIndices.getFirst().keySet().stream().filter(length -> separatorIndices.stream().allMatch(map -> map.containsKey(length))).toList();
        if (matchingSeparatorLengths.isEmpty()) {
            this.bigSignWriter$clearSign();
            return;
        }
        int index = Collections.min(matchingSeparatorLengths);
        for (int i = 0; i < this.messages.length; ++i) {
            String message2 = this.messages[i];
            this.line = i;
            this.setMessage(message2.substring(0, (Integer)separatorIndices.get(i).get(index)));
        }
        if (this.signField != null) {
            this.signField.setCursorToEnd();
        }
    }

    @Inject(method={"renderSignText"}, at={@At(value="FIELD", target="Lnet/minecraft/client/gui/screens/inventory/AbstractSignEditScreen;messages:[Ljava/lang/String;", ordinal=2)}, cancellable=true)
    private void drawExtraLines(GuiGraphics guiGraphics, CallbackInfo ci, @Local boolean blink, @Local(ordinal=0) int color) {
        if (!BigSignWriter.ENABLED) {
            return;
        }
        int lineHeight = this.sign.getTextLineHeight();
        int opaqueColor = 0xFF000000 | color;
        for (int i = 0; i < this.messages.length; ++i) {
            if (!blink) continue;
            String string = this.messages[i] == null ? "" : this.messages[i];
            int lineX = this.font.width(string) / 2;
            int lineY = (i - 2) * lineHeight;
            guiGraphics.fill(lineX, lineY - 1, lineX + 1, lineY + lineHeight, opaqueColor);
        }
        ci.cancel();
    }

    @WrapWithCondition(method={"renderSignText"}, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)I")})
    private boolean hideUnderscore(GuiGraphics instance, Font font, String string, int i, int j, int k, boolean bl) {
        return !BigSignWriter.ENABLED;
    }
}

