/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.editor.ui;

import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.editor.ui.ImGuiHelper;
import com.moulberry.flashback.editor.ui.ReplayUI;
import com.moulberry.flashback.exporting.AsyncFileDialogs;
import imgui.ImGui;
import imgui.ImGuiIO;
import imgui.ImGuiPlatformIO;
import imgui.ImGuiViewport;
import imgui.ImVec2;
import imgui.callback.ImPlatformFuncViewport;
import imgui.callback.ImPlatformFuncViewportFloat;
import imgui.callback.ImPlatformFuncViewportImVec2;
import imgui.callback.ImPlatformFuncViewportString;
import imgui.callback.ImPlatformFuncViewportSuppBoolean;
import imgui.callback.ImPlatformFuncViewportSuppImVec2;
import imgui.callback.ImStrConsumer;
import imgui.callback.ImStrSupplier;
import imgui.lwjgl3.glfw.ImGuiImplGlfwNative;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import net.minecraft.class_304;
import net.minecraft.class_310;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharModsCallback;
import org.lwjgl.glfw.GLFWCursorEnterCallback;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWMonitorCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWNativeWin32;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowFocusCallback;

public class CustomImGuiImplGlfw {
    private static final String OS = System.getProperty("os.name", "generic").toLowerCase();
    public static final boolean IS_WINDOWS = OS.contains("win");
    protected static final boolean IS_APPLE = OS.contains("mac") || OS.contains("darwin");
    private long mainWindowPtr;
    private boolean glfwHawWindowTopmost;
    private boolean glfwHasWindowAlpha;
    private boolean glfwHasPerMonitorDpi;
    private boolean glfwHasFocusWindow;
    private boolean glfwHasFocusOnShow;
    private boolean glfwHasMonitorWorkArea;
    private boolean glfwHasOsxWindowPosFix;
    private final int[] winWidth = new int[1];
    private final int[] winHeight = new int[1];
    private final int[] fbWidth = new int[1];
    private final int[] fbHeight = new int[1];
    private final float[] windowScaleX = new float[1];
    private final float[] windowScaleY = new float[1];
    private final long[] mouseCursors = new long[9];
    private final long[] keyOwnerWindows = new long[512];
    private final boolean[] keyPressedGame = new boolean[512];
    private final float[] emptyNavInputs = new float[21];
    private final boolean[] mouseJustPressed = new boolean[5];
    private final ImVec2 mousePosBackup = new ImVec2();
    private final double[] mouseX = new double[1];
    private final double[] mouseY = new double[1];
    private final int[] windowX = new int[1];
    private final int[] windowY = new int[1];
    private final int[] monitorX = new int[1];
    private final int[] monitorY = new int[1];
    private final int[] monitorWorkAreaX = new int[1];
    private final int[] monitorWorkAreaY = new int[1];
    private final int[] monitorWorkAreaWidth = new int[1];
    private final int[] monitorWorkAreaHeight = new int[1];
    private final float[] monitorContentScaleX = new float[1];
    private final float[] monitorContentScaleY = new float[1];
    private GLFWWindowFocusCallback prevUserCallbackWindowFocus = null;
    private GLFWMouseButtonCallback prevUserCallbackMouseButton = null;
    private GLFWScrollCallback prevUserCallbackScroll = null;
    private GLFWCursorPosCallback prevUserCallbackCursorPos = null;
    private GLFWKeyCallback prevUserCallbackKey = null;
    private GLFWCharModsCallback prevUserCallbackChar = null;
    private GLFWMonitorCallback prevUserCallbackMonitor = null;
    private GLFWCursorEnterCallback prevUserCallbackCursorEnter = null;
    private boolean callbacksInstalled = false;
    private boolean wantUpdateMonitors = true;
    private double time = 0.0;
    private long mouseWindowPtr;
    private MouseHandledBy grabbed = null;
    private int ignoreMouseMovements = 0;
    private boolean releasedAllKeysBecauseOfDialog = false;
    private boolean releasedAllKeysBecauseOfDisable = false;
    private final double[] grabbedOriginalMouseX = new double[1];
    private final double[] grabbedOriginalMouseY = new double[1];
    private int grabLinkedKey = -1;
    private boolean releaseGrabOnUp = false;
    public double rawMouseX;
    public double rawMouseY;
    public float contentScale = 1.0f;
    private static double grabbedLastMouseX = 0.0;
    private static double grabbedLastMouseY = 0.0;
    private static double grabbedCurrMouseX = 0.0;
    private static double grabbedCurrMouseY = 0.0;
    private final int[] keyMap = new int[22];
    private boolean viewportWindowsHidden;

    public CustomImGuiImplGlfw() {
        this.keyMap[0] = -1;
        this.keyMap[1] = 263;
        this.keyMap[2] = 262;
        this.keyMap[3] = 265;
        this.keyMap[4] = 264;
        this.keyMap[5] = 266;
        this.keyMap[6] = 267;
        this.keyMap[7] = 268;
        this.keyMap[8] = 269;
        this.keyMap[9] = 260;
        this.keyMap[10] = 261;
        this.keyMap[11] = 259;
        this.keyMap[12] = 32;
        this.keyMap[13] = 257;
        this.keyMap[14] = 256;
        this.keyMap[15] = 335;
        this.keyMap[16] = 65;
        this.keyMap[17] = 67;
        this.keyMap[18] = 86;
        this.keyMap[19] = 88;
        this.keyMap[20] = 89;
        this.keyMap[21] = 90;
        this.viewportWindowsHidden = false;
    }

    public MouseHandledBy getMouseHandledBy() {
        if (!ReplayUI.isActive()) {
            return MouseHandledBy.GAME;
        }
        if (this.grabbed != null) {
            return this.grabbed;
        }
        if (ReplayUI.getIO().getWantCaptureMouse()) {
            return MouseHandledBy.IMGUI;
        }
        return MouseHandledBy.BOTH;
    }

    public boolean isGrabbed() {
        return this.grabbed != null;
    }

    public void ungrab() {
        if (this.grabbed == null) {
            return;
        }
        this.grabbed = null;
        this.grabLinkedKey = 0;
        GLFW.glfwSetInputMode((long)this.mainWindowPtr, (int)208897, (int)212993);
        GLFW.glfwSetCursorPos((long)this.mainWindowPtr, (double)this.grabbedOriginalMouseX[0], (double)this.grabbedOriginalMouseY[0]);
    }

    public void setGrabbed(boolean passthroughToGame, int grabLinkedKey, boolean releaseGrabOnUp, double x, double y) {
        if (grabLinkedKey != 0) {
            if (grabLinkedKey < 0) {
                if (GLFW.glfwGetMouseButton((long)this.mainWindowPtr, (int)(-grabLinkedKey - 1)) == 0) {
                    this.ungrab();
                    return;
                }
            } else if (GLFW.glfwGetKey((long)this.mainWindowPtr, (int)grabLinkedKey) == 0) {
                this.ungrab();
                return;
            }
        }
        if (this.grabbed != null) {
            return;
        }
        MouseHandledBy mouseHandledBy = this.grabbed = passthroughToGame ? MouseHandledBy.GAME : MouseHandledBy.EDITOR_GRABBED;
        if (grabLinkedKey != 0) {
            this.grabLinkedKey = grabLinkedKey;
            this.releaseGrabOnUp = releaseGrabOnUp;
        }
        if (x >= 0.0 && y >= 0.0) {
            this.grabbedOriginalMouseX[0] = x;
            this.grabbedOriginalMouseY[0] = y;
        } else {
            GLFW.glfwGetCursorPos((long)this.mainWindowPtr, (double[])this.grabbedOriginalMouseX, (double[])this.grabbedOriginalMouseY);
        }
        GLFW.glfwSetInputMode((long)this.mainWindowPtr, (int)208897, (int)212995);
        this.ignoreMouseMovements = 2;
        class_310.method_1551().field_1729.method_1599();
    }

    public double getGrabbedMouseDeltaX() {
        double delta = grabbedCurrMouseX - grabbedLastMouseX;
        grabbedLastMouseX = grabbedCurrMouseX;
        return delta;
    }

    public double getGrabbedMouseDeltaY() {
        double delta = grabbedCurrMouseY - grabbedLastMouseY;
        grabbedLastMouseY = grabbedCurrMouseY;
        return delta;
    }

    public void mouseButtonCallback(long windowId, int button, int action, int mods) {
        MouseHandledBy handledBy;
        if (AsyncFileDialogs.hasDialog()) {
            return;
        }
        if (!ReplayUI.isActive()) {
            if (this.prevUserCallbackMouseButton != null && windowId == this.mainWindowPtr) {
                this.prevUserCallbackMouseButton.invoke(windowId, button, action, mods);
            }
            return;
        }
        if (this.grabbed != null && this.grabLinkedKey < 0 && button == -this.grabLinkedKey - 1 && action == 0 == this.releaseGrabOnUp) {
            this.ungrab();
        }
        if ((handledBy = this.getMouseHandledBy()).allowGame() && this.prevUserCallbackMouseButton != null && windowId == this.mainWindowPtr) {
            this.prevUserCallbackMouseButton.invoke(windowId, button, action, mods);
        }
        if (handledBy.allowImgui() && action == 1 && button >= 0 && button < this.mouseJustPressed.length) {
            this.mouseJustPressed[button] = true;
        }
    }

    public void scrollCallback(long windowId, double xOffset, double yOffset) {
        if (AsyncFileDialogs.hasDialog()) {
            return;
        }
        if (ReplayUI.isActive()) {
            ImGuiIO io = ReplayUI.getIO();
            io.setMouseWheelH(io.getMouseWheelH() + (float)xOffset);
            io.setMouseWheel(io.getMouseWheel() + (float)yOffset);
            if (class_310.method_1551().field_1755 == null || !ReplayUI.isMainFrameActive()) {
                return;
            }
        }
        if (this.prevUserCallbackScroll != null && windowId == this.mainWindowPtr) {
            this.prevUserCallbackScroll.invoke(windowId, 0.0, yOffset);
        }
    }

    public void keyCallback(long windowId, int key, int scancode, int action, int mods) {
        boolean forcePassToGame;
        boolean keyInBoundsForGame;
        if (AsyncFileDialogs.hasDialog()) {
            return;
        }
        if (key < 32 || key > 348) {
            if (this.prevUserCallbackKey != null && windowId == this.mainWindowPtr) {
                this.prevUserCallbackKey.invoke(windowId, key, scancode, action, mods);
            }
            return;
        }
        boolean shiftMod = (mods & 1) != 0;
        boolean ctrlMod = (mods & 2) != 0;
        boolean altMod = (mods & 4) != 0;
        boolean superMod = (mods & 8) != 0;
        int minecraftKey = key;
        boolean bl = keyInBoundsForGame = minecraftKey >= 0 && minecraftKey < this.keyPressedGame.length;
        if (this.grabbed != null && action == 0 && this.grabLinkedKey > 0 && key == this.grabLinkedKey) {
            this.ungrab();
        }
        ImGuiIO io = ReplayUI.getIO();
        if (!ReplayUI.isActive() || class_310.method_1551().field_1755 != null) {
            if (action == 0 && key >= 0 && key < this.keyOwnerWindows.length) {
                io.setKeysDown(key, false);
                this.keyOwnerWindows[key] = 0L;
            }
            if (this.prevUserCallbackKey != null && windowId == this.mainWindowPtr) {
                if (keyInBoundsForGame) {
                    boolean bl2 = this.keyPressedGame[minecraftKey] = action != 0;
                }
                if (Flashback.isExporting()) {
                    if (action == 0 && keyInBoundsForGame && this.keyPressedGame[minecraftKey]) {
                        this.keyPressedGame[minecraftKey] = false;
                    } else {
                        return;
                    }
                }
                this.prevUserCallbackKey.invoke(windowId, minecraftKey, scancode, action, mods);
            }
            return;
        }
        if (action == 1 && ImGuiHelper.getWantsSpecialInput()) {
            if (key == 259 && ImGuiHelper.backspaceInput(mods)) {
                return;
            }
            if (key == 32) {
                return;
            }
        }
        boolean bl3 = forcePassToGame = action != 0 && (key == 256 && !io.getWantTextInput() && !ReplayUI.hasAnyPopupOpen || key >= 290 && key <= 314 || GLFW.glfwGetKey((long)windowId, (int)292) != 0);
        if (forcePassToGame) {
            this.prevUserCallbackKey.invoke(windowId, minecraftKey, scancode, action, mods);
            if (keyInBoundsForGame) {
                this.keyPressedGame[minecraftKey] = true;
            }
            return;
        }
        boolean passToMinecraft = false;
        boolean passToImGui = false;
        if (action == 0) {
            if (keyInBoundsForGame && this.keyPressedGame[minecraftKey]) {
                passToMinecraft = true;
            }
            if (key >= 0 && key < this.keyOwnerWindows.length) {
                passToImGui = true;
            }
        } else {
            if (io.getWantTextInput()) {
                passToMinecraft = false;
            } else if (this.grabbed == MouseHandledBy.GAME) {
                passToMinecraft = true;
            } else if (ReplayUI.isMainFrameActive()) {
                for (class_304 keyMapping : class_310.method_1551().field_1690.field_1839) {
                    if (!keyMapping.method_1417(key, scancode)) continue;
                    passToMinecraft = true;
                    break;
                }
            } else if (class_310.method_1551().field_1690.field_1894.method_1417(key, scancode) || class_310.method_1551().field_1690.field_1913.method_1417(key, scancode) || class_310.method_1551().field_1690.field_1881.method_1417(key, scancode) || class_310.method_1551().field_1690.field_1849.method_1417(key, scancode) || class_310.method_1551().field_1690.field_1903.method_1417(key, scancode) || class_310.method_1551().field_1690.field_1890.method_1417(key, scancode) || class_310.method_1551().field_1690.field_1845.method_1417(key, scancode)) {
                ReplayUI.focusMainWindowCounter = 5;
                passToMinecraft = true;
            }
            boolean bl4 = passToImGui = !passToMinecraft;
        }
        if (passToMinecraft && this.prevUserCallbackKey != null && windowId == this.mainWindowPtr) {
            this.prevUserCallbackKey.invoke(windowId, minecraftKey, scancode, action, mods);
            if (keyInBoundsForGame) {
                boolean bl5 = this.keyPressedGame[minecraftKey] = action != 0;
            }
        }
        if (passToImGui && key >= 0 && key < this.keyOwnerWindows.length) {
            if (action == 1 || action == 2) {
                io.setKeysDown(key, true);
                this.keyOwnerWindows[key] = windowId;
            } else if (action == 0) {
                io.setKeysDown(key, false);
                this.keyOwnerWindows[key] = 0L;
            }
        }
    }

    public void cursorPosCallback(long windowId, double xpos, double ypos) {
        if (AsyncFileDialogs.hasDialog()) {
            return;
        }
        this.rawMouseX = xpos;
        this.rawMouseY = ypos;
        if (!ReplayUI.isActive()) {
            if (this.prevUserCallbackCursorPos != null && windowId == this.mainWindowPtr) {
                this.prevUserCallbackCursorPos.invoke(windowId, xpos, ypos);
            }
            return;
        }
        MouseHandledBy handledBy = this.getMouseHandledBy();
        if (this.ignoreMouseMovements > 0) {
            grabbedCurrMouseX = xpos;
            grabbedCurrMouseY = ypos;
            grabbedLastMouseX = xpos;
            grabbedLastMouseY = ypos;
            --this.ignoreMouseMovements;
            return;
        }
        if (handledBy.allowGame() && this.prevUserCallbackCursorPos != null && windowId == this.mainWindowPtr) {
            this.prevUserCallbackCursorPos.invoke(windowId, ReplayUI.getNewMouseX(xpos), ReplayUI.getNewMouseY(ypos));
        }
        if (handledBy == MouseHandledBy.EDITOR_GRABBED) {
            grabbedCurrMouseX = xpos;
            grabbedCurrMouseY = ypos;
        }
    }

    public void windowFocusCallback(long windowId, boolean focused) {
        if (this.prevUserCallbackWindowFocus != null && windowId == this.mainWindowPtr) {
            this.prevUserCallbackWindowFocus.invoke(windowId, focused);
        }
        ReplayUI.getIO().addFocusEvent(focused);
    }

    public void cursorEnterCallback(long windowId, boolean entered) {
        if (this.prevUserCallbackCursorEnter != null && windowId == this.mainWindowPtr) {
            this.prevUserCallbackCursorEnter.invoke(windowId, entered);
        }
        if (entered) {
            this.mouseWindowPtr = windowId;
        }
        if (!entered && this.mouseWindowPtr == windowId) {
            this.mouseWindowPtr = 0L;
        }
    }

    public void charCallback(long windowId, int c, int mods) {
        if (AsyncFileDialogs.hasDialog()) {
            return;
        }
        if (!ReplayUI.isActive()) {
            if (this.prevUserCallbackChar != null && windowId == this.mainWindowPtr) {
                this.prevUserCallbackChar.invoke(windowId, c, mods);
            }
            return;
        }
        ImGuiIO io = ReplayUI.getIO();
        if (!io.getWantCaptureKeyboard() && !io.getWantTextInput() && this.prevUserCallbackChar != null && windowId == this.mainWindowPtr) {
            this.prevUserCallbackChar.invoke(windowId, c, mods);
        }
        if (!ImGuiHelper.addInputCharacter((char)c)) {
            io.addInputCharacter(c);
        }
    }

    public void monitorCallback(long windowId, int event) {
        if (this.prevUserCallbackMonitor != null && windowId == this.mainWindowPtr) {
            this.prevUserCallbackMonitor.invoke(windowId, event);
        }
        this.wantUpdateMonitors = true;
    }

    public void enableTabInput() {
        this.keyMap[0] = 258;
        ReplayUI.getIO().setKeyMap(this.keyMap);
    }

    public void disableTabInput() {
        this.keyMap[0] = -1;
        ReplayUI.getIO().setKeyMap(this.keyMap);
    }

    public boolean init(final long windowId, boolean installCallbacks) {
        this.mainWindowPtr = windowId;
        this.detectGlfwVersionAndEnabledFeatures();
        ImGuiIO io = ReplayUI.getIO();
        io.addBackendFlags(1030);
        io.setBackendPlatformName("imgui_java_impl_glfw");
        io.setKeyMap(this.keyMap);
        io.setGetClipboardTextFn(new ImStrSupplier(this){

            @Override
            public String get() {
                String clipboardString = GLFW.glfwGetClipboardString((long)windowId);
                return clipboardString != null ? clipboardString : "";
            }
        });
        io.setSetClipboardTextFn(new ImStrConsumer(this){

            @Override
            public void accept(String str) {
                GLFW.glfwSetClipboardString((long)windowId, (CharSequence)str);
            }
        });
        GLFWErrorCallback prevErrorCallback = GLFW.glfwSetErrorCallback(null);
        this.mouseCursors[0] = GLFW.glfwCreateStandardCursor((int)221185);
        this.mouseCursors[1] = GLFW.glfwCreateStandardCursor((int)221186);
        this.mouseCursors[2] = GLFW.glfwCreateStandardCursor((int)221193);
        this.mouseCursors[3] = GLFW.glfwCreateStandardCursor((int)221190);
        this.mouseCursors[4] = GLFW.glfwCreateStandardCursor((int)221189);
        this.mouseCursors[5] = GLFW.glfwCreateStandardCursor((int)221185);
        this.mouseCursors[6] = GLFW.glfwCreateStandardCursor((int)221185);
        this.mouseCursors[7] = GLFW.glfwCreateStandardCursor((int)221188);
        this.mouseCursors[8] = GLFW.glfwCreateStandardCursor((int)221185);
        GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)prevErrorCallback);
        if (installCallbacks) {
            this.callbacksInstalled = true;
            this.prevUserCallbackWindowFocus = GLFW.glfwSetWindowFocusCallback((long)windowId, this::windowFocusCallback);
            this.prevUserCallbackCursorEnter = GLFW.glfwSetCursorEnterCallback((long)windowId, this::cursorEnterCallback);
            this.prevUserCallbackMouseButton = GLFW.glfwSetMouseButtonCallback((long)windowId, this::mouseButtonCallback);
            this.prevUserCallbackScroll = GLFW.glfwSetScrollCallback((long)windowId, this::scrollCallback);
            this.prevUserCallbackCursorPos = GLFW.glfwSetCursorPosCallback((long)windowId, this::cursorPosCallback);
            this.prevUserCallbackKey = GLFW.glfwSetKeyCallback((long)windowId, this::keyCallback);
            this.prevUserCallbackChar = GLFW.glfwSetCharModsCallback((long)windowId, this::charCallback);
            this.prevUserCallbackMonitor = GLFW.glfwSetMonitorCallback(this::monitorCallback);
        }
        GLFW.glfwGetWindowSize((long)this.mainWindowPtr, (int[])this.winWidth, (int[])this.winHeight);
        GLFW.glfwGetFramebufferSize((long)this.mainWindowPtr, (int[])this.fbWidth, (int[])this.fbHeight);
        io.setDisplaySize(this.winWidth[0], this.winHeight[0]);
        if (this.winWidth[0] > 0 && this.winHeight[0] > 0) {
            float scaleX = (float)this.fbWidth[0] / (float)this.winWidth[0];
            float scaleY = (float)this.fbHeight[0] / (float)this.winHeight[0];
            io.setDisplayFramebufferScale(scaleX, scaleY);
            GLFW.glfwGetWindowContentScale((long)class_310.method_1551().method_22683().method_4490(), (float[])this.windowScaleX, (float[])this.windowScaleY);
            this.contentScale = Math.max(this.windowScaleX[0] / scaleX, this.windowScaleY[0] / scaleY);
        }
        this.updateMonitors();
        GLFW.glfwSetMonitorCallback(this::monitorCallback);
        ImGuiViewport mainViewport = ImGui.getMainViewport();
        mainViewport.setPlatformHandle(this.mainWindowPtr);
        if (IS_WINDOWS) {
            mainViewport.setPlatformHandleRaw(GLFWNativeWin32.glfwGetWin32Window((long)windowId));
        }
        if (io.hasConfigFlags(1024)) {
            this.initPlatformInterface();
        }
        return true;
    }

    public void newFrame() {
        ImGuiIO io = ReplayUI.getIO();
        GLFW.glfwGetWindowSize((long)this.mainWindowPtr, (int[])this.winWidth, (int[])this.winHeight);
        GLFW.glfwGetFramebufferSize((long)this.mainWindowPtr, (int[])this.fbWidth, (int[])this.fbHeight);
        io.setDisplaySize(this.winWidth[0], this.winHeight[0]);
        if (this.winWidth[0] > 0 && this.winHeight[0] > 0) {
            float scaleX = (float)this.fbWidth[0] / (float)this.winWidth[0];
            float scaleY = (float)this.fbHeight[0] / (float)this.winHeight[0];
            io.setDisplayFramebufferScale(scaleX, scaleY);
            GLFW.glfwGetWindowContentScale((long)class_310.method_1551().method_22683().method_4490(), (float[])this.windowScaleX, (float[])this.windowScaleY);
            this.contentScale = Math.max(this.windowScaleX[0] / scaleX, this.windowScaleY[0] / scaleY);
        }
        if (this.wantUpdateMonitors) {
            this.updateMonitors();
        }
        double currentTime = GLFW.glfwGetTime();
        io.setDeltaTime(this.time > 0.0 ? (float)(currentTime - this.time) : 0.016666668f);
        this.time = currentTime;
        if (AsyncFileDialogs.hasDialog()) {
            if (!this.releasedAllKeysBecauseOfDialog) {
                int key;
                this.releasedAllKeysBecauseOfDialog = true;
                for (key = 0; key < this.keyPressedGame.length; ++key) {
                    if (!this.keyPressedGame[key]) continue;
                    int scancode = GLFW.glfwGetKeyScancode((int)key);
                    this.prevUserCallbackKey.invoke(this.mainWindowPtr, key, scancode, 0, 0);
                }
                for (key = 0; key < this.keyOwnerWindows.length; ++key) {
                    io.setKeysDown(key, false);
                    this.keyOwnerWindows[key] = 0L;
                }
                io.setKeyCtrl(false);
                io.setKeyShift(false);
                io.setKeyAlt(false);
                io.setKeySuper(false);
            }
            return;
        }
        this.releasedAllKeysBecauseOfDialog = false;
        boolean shiftDown = false;
        boolean ctrlDown = false;
        boolean altDown = false;
        boolean superDown = false;
        ImGuiPlatformIO platformIO = ImGui.getPlatformIO();
        for (int n = 0; n < platformIO.getViewportsSize(); ++n) {
            ImGuiViewport viewport = platformIO.getViewports(n);
            long windowPtr = viewport.getPlatformHandle();
            if (GLFW.glfwGetWindowAttrib((long)windowPtr, (int)131073) == 0) continue;
            shiftDown |= GLFW.glfwGetKey((long)windowPtr, (int)340) != 0 || GLFW.glfwGetKey((long)windowPtr, (int)344) != 0;
            ctrlDown |= GLFW.glfwGetKey((long)windowPtr, (int)341) != 0 || GLFW.glfwGetKey((long)windowPtr, (int)345) != 0;
            altDown |= GLFW.glfwGetKey((long)windowPtr, (int)342) != 0 || GLFW.glfwGetKey((long)windowPtr, (int)346) != 0;
            superDown |= GLFW.glfwGetKey((long)windowPtr, (int)343) != 0 || GLFW.glfwGetKey((long)windowPtr, (int)347) != 0;
        }
        io.setKeyShift(shiftDown);
        io.setKeyCtrl(ctrlDown);
        io.setKeyAlt(altDown);
        io.setKeySuper(superDown);
        this.updateMousePosAndButtons();
        this.updateMouseCursor();
        this.updateGamepads();
    }

    public void updateReleaseAllKeys(boolean release) {
        if (release) {
            if (!this.releasedAllKeysBecauseOfDisable) {
                this.releasedAllKeysBecauseOfDisable = true;
                ImGuiIO io = ReplayUI.getIO();
                for (int key = 0; key < this.keyOwnerWindows.length; ++key) {
                    io.setKeysDown(key, false);
                    this.keyOwnerWindows[key] = 0L;
                }
                io.setKeyCtrl(false);
                io.setKeyShift(false);
                io.setKeyAlt(false);
                io.setKeySuper(false);
                ImGuiPlatformIO platformIO = ImGui.getPlatformIO();
                for (int n = 0; n < platformIO.getViewportsSize(); ++n) {
                    long windowPtr = platformIO.getViewports(n).getPlatformHandle();
                    GLFW.glfwSetCursor((long)windowPtr, (long)this.mouseCursors[0]);
                }
            }
        } else {
            this.releasedAllKeysBecauseOfDisable = false;
        }
    }

    private void detectGlfwVersionAndEnabledFeatures() {
        int[] major = new int[1];
        int[] minor = new int[1];
        int[] rev = new int[1];
        GLFW.glfwGetVersion((int[])major, (int[])minor, (int[])rev);
        int version = major[0] * 1000 + minor[0] * 100 + rev[0] * 10;
        this.glfwHawWindowTopmost = version >= 3200;
        this.glfwHasWindowAlpha = version >= 3300;
        this.glfwHasPerMonitorDpi = version >= 3300;
        this.glfwHasFocusWindow = version >= 3200;
        this.glfwHasFocusOnShow = version >= 3300;
        this.glfwHasMonitorWorkArea = version >= 3300;
    }

    private void updateMousePosAndButtons() {
        ImGuiIO io = ReplayUI.getIO();
        MouseHandledBy mouseHandledBy = this.getMouseHandledBy();
        if (!mouseHandledBy.allowImgui() || AsyncFileDialogs.hasDialog()) {
            for (int i = 0; i < 5; ++i) {
                io.setMouseDown(i, false);
                this.mouseJustPressed[i] = false;
            }
            return;
        }
        for (int i = 0; i < 5; ++i) {
            io.setMouseDown(i, this.mouseJustPressed[i] || GLFW.glfwGetMouseButton((long)this.mainWindowPtr, (int)i) != 0);
            this.mouseJustPressed[i] = false;
        }
        io.getMousePos(this.mousePosBackup);
        io.setMousePos(-3.4028235E38f, -3.4028235E38f);
        io.setMouseHoveredViewport(0);
        ImGuiPlatformIO platformIO = ImGui.getPlatformIO();
        for (int n = 0; n < platformIO.getViewportsSize(); ++n) {
            boolean focused;
            ImGuiViewport viewport = platformIO.getViewports(n);
            long windowPtr = viewport.getPlatformHandle();
            boolean bl = focused = GLFW.glfwGetWindowAttrib((long)windowPtr, (int)131073) != 0;
            if (focused) {
                for (int i = 0; i < 5; ++i) {
                    if (io.getMouseDown(i)) continue;
                    io.setMouseDown(i, GLFW.glfwGetMouseButton((long)windowPtr, (int)i) != 0);
                }
            }
            if (io.getWantSetMousePos() && focused) {
                GLFW.glfwSetCursorPos((long)windowPtr, (double)(this.mousePosBackup.x - viewport.getPosX()), (double)(this.mousePosBackup.y - viewport.getPosY()));
            }
            if (this.mouseWindowPtr != windowPtr && !focused) continue;
            GLFW.glfwGetCursorPos((long)windowPtr, (double[])this.mouseX, (double[])this.mouseY);
            if (io.hasConfigFlags(1024)) {
                GLFW.glfwGetWindowPos((long)windowPtr, (int[])this.windowX, (int[])this.windowY);
                io.setMousePos((float)this.mouseX[0] + (float)this.windowX[0], (float)this.mouseY[0] + (float)this.windowY[0]);
                continue;
            }
            io.setMousePos((float)this.mouseX[0], (float)this.mouseY[0]);
        }
    }

    private void updateMouseCursor() {
        boolean cursorDisabled;
        if (AsyncFileDialogs.hasDialog()) {
            return;
        }
        ImGuiIO io = ReplayUI.getIO();
        boolean noCursorChange = io.hasConfigFlags(32);
        boolean bl = cursorDisabled = GLFW.glfwGetInputMode((long)this.mainWindowPtr, (int)208897) == 212995;
        if (noCursorChange || cursorDisabled) {
            return;
        }
        int imguiCursor = ImGui.getMouseCursor();
        ImGuiPlatformIO platformIO = ImGui.getPlatformIO();
        for (int n = 0; n < platformIO.getViewportsSize(); ++n) {
            long windowPtr = platformIO.getViewports(n).getPlatformHandle();
            if (imguiCursor == -1 || io.getMouseDrawCursor()) {
                GLFW.glfwSetInputMode((long)windowPtr, (int)208897, (int)212994);
                continue;
            }
            GLFW.glfwSetCursor((long)windowPtr, (long)(this.mouseCursors[imguiCursor] != 0L ? this.mouseCursors[imguiCursor] : this.mouseCursors[0]));
            GLFW.glfwSetInputMode((long)windowPtr, (int)208897, (int)212993);
        }
    }

    private void updateGamepads() {
        if (AsyncFileDialogs.hasDialog()) {
            return;
        }
        ImGuiIO io = ReplayUI.getIO();
        if (!io.hasConfigFlags(2)) {
            return;
        }
        io.setNavInputs(this.emptyNavInputs);
        ByteBuffer buttons = GLFW.glfwGetJoystickButtons((int)0);
        int buttonsCount = buttons.limit();
        FloatBuffer axis = GLFW.glfwGetJoystickAxes((int)0);
        int axisCount = axis.limit();
        this.mapButton(0, 0, buttons, buttonsCount, io);
        this.mapButton(1, 1, buttons, buttonsCount, io);
        this.mapButton(3, 2, buttons, buttonsCount, io);
        this.mapButton(2, 3, buttons, buttonsCount, io);
        this.mapButton(4, 13, buttons, buttonsCount, io);
        this.mapButton(5, 11, buttons, buttonsCount, io);
        this.mapButton(6, 10, buttons, buttonsCount, io);
        this.mapButton(7, 12, buttons, buttonsCount, io);
        this.mapButton(12, 4, buttons, buttonsCount, io);
        this.mapButton(13, 5, buttons, buttonsCount, io);
        this.mapButton(14, 4, buttons, buttonsCount, io);
        this.mapButton(15, 5, buttons, buttonsCount, io);
        this.mapAnalog(8, 0, -0.3f, -0.9f, axis, axisCount, io);
        this.mapAnalog(9, 0, 0.3f, 0.9f, axis, axisCount, io);
        this.mapAnalog(10, 1, 0.3f, 0.9f, axis, axisCount, io);
        this.mapAnalog(11, 1, -0.3f, -0.9f, axis, axisCount, io);
        if (axisCount > 0 && buttonsCount > 0) {
            io.addBackendFlags(1);
        } else {
            io.removeBackendFlags(1);
        }
    }

    private void mapButton(int navNo, int buttonNo, ByteBuffer buttons, int buttonsCount, ImGuiIO io) {
        if (buttonsCount > buttonNo && buttons.get(buttonNo) == 1) {
            io.setNavInputs(navNo, 1.0f);
        }
    }

    private void mapAnalog(int navNo, int axisNo, float v0, float v1, FloatBuffer axis, int axisCount, ImGuiIO io) {
        float v = axisCount > axisNo ? axis.get(axisNo) : v0;
        if ((v = (v - v0) / (v1 - v0)) > 1.0f) {
            v = 1.0f;
        }
        if (io.getNavInputs(navNo) < v) {
            io.setNavInputs(navNo, v);
        }
    }

    private void updateMonitors() {
        ImGuiPlatformIO platformIO = ImGui.getPlatformIO();
        PointerBuffer monitors = GLFW.glfwGetMonitors();
        platformIO.resizeMonitors(0);
        for (int n = 0; n < monitors.limit(); ++n) {
            long monitor = monitors.get(n);
            GLFW.glfwGetMonitorPos((long)monitor, (int[])this.monitorX, (int[])this.monitorY);
            GLFWVidMode vidMode = GLFW.glfwGetVideoMode((long)monitor);
            float mainPosX = this.monitorX[0];
            float mainPosY = this.monitorY[0];
            float mainSizeX = vidMode.width();
            float mainSizeY = vidMode.height();
            if (this.glfwHasMonitorWorkArea) {
                GLFW.glfwGetMonitorWorkarea((long)monitor, (int[])this.monitorWorkAreaX, (int[])this.monitorWorkAreaY, (int[])this.monitorWorkAreaWidth, (int[])this.monitorWorkAreaHeight);
            }
            float workPosX = 0.0f;
            float workPosY = 0.0f;
            float workSizeX = 0.0f;
            float workSizeY = 0.0f;
            if (this.glfwHasMonitorWorkArea && this.monitorWorkAreaWidth[0] > 0 && this.monitorWorkAreaHeight[0] > 0) {
                workPosX = this.monitorWorkAreaX[0];
                workPosY = this.monitorWorkAreaY[0];
                workSizeX = this.monitorWorkAreaWidth[0];
                workSizeY = this.monitorWorkAreaHeight[0];
            }
            if (this.glfwHasPerMonitorDpi) {
                GLFW.glfwGetMonitorContentScale((long)monitor, (float[])this.monitorContentScaleX, (float[])this.monitorContentScaleY);
            }
            float dpiScale = this.monitorContentScaleX[0];
            platformIO.pushMonitors(mainPosX, mainPosY, mainSizeX, mainSizeY, workPosX, workPosY, workSizeX, workSizeY, dpiScale);
        }
        this.wantUpdateMonitors = false;
    }

    public void setViewportWindowsHidden(boolean viewportWindowsHidden) {
        if (this.viewportWindowsHidden == viewportWindowsHidden) {
            return;
        }
        if (!this.viewportWindowsHidden) {
            this.viewportWindowsHidden = true;
            ImGuiPlatformIO platformIO = ImGui.getPlatformIO();
            for (int n = 0; n < platformIO.getViewportsSize(); ++n) {
                long windowPtr = platformIO.getViewports(n).getPlatformHandle();
                if (windowPtr == this.mainWindowPtr) continue;
                GLFW.glfwHideWindow((long)windowPtr);
            }
        } else {
            this.viewportWindowsHidden = false;
            ImGuiPlatformIO platformIO = ImGui.getPlatformIO();
            for (int n = 0; n < platformIO.getViewportsSize(); ++n) {
                long windowPtr = platformIO.getViewports(n).getPlatformHandle();
                if (windowPtr == this.mainWindowPtr) continue;
                GLFW.glfwShowWindow((long)windowPtr);
            }
        }
    }

    private void windowCloseCallback(long windowId) {
        ImGuiViewport vp = ImGui.findViewportByPlatformHandle(windowId);
        vp.setPlatformRequestClose(true);
    }

    private void windowPosCallback(long windowId, int xPos, int yPos) {
        boolean ignoreEvent;
        ImGuiViewport vp = ImGui.findViewportByPlatformHandle(windowId);
        ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
        boolean bl = ignoreEvent = ImGui.getFrameCount() <= data.ignoreWindowPosEventFrame + 1;
        if (ignoreEvent) {
            return;
        }
        vp.setPlatformRequestMove(true);
    }

    private void windowSizeCallback(long windowId, int width, int height) {
        boolean ignoreEvent;
        ImGuiViewport vp = ImGui.findViewportByPlatformHandle(windowId);
        ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
        boolean bl = ignoreEvent = ImGui.getFrameCount() <= data.ignoreWindowSizeEventFrame + 1;
        if (ignoreEvent) {
            return;
        }
        vp.setPlatformRequestResize(true);
    }

    private void initPlatformInterface() {
        ImGuiPlatformIO platformIO = ImGui.getPlatformIO();
        platformIO.setPlatformCreateWindow(new CreateWindowFunction());
        platformIO.setPlatformDestroyWindow(new DestroyWindowFunction());
        platformIO.setPlatformShowWindow(new ShowWindowFunction());
        platformIO.setPlatformGetWindowPos(new GetWindowPosFunction());
        platformIO.setPlatformSetWindowPos(new SetWindowPosFunction());
        platformIO.setPlatformGetWindowSize(new GetWindowSizeFunction());
        platformIO.setPlatformSetWindowSize(new SetWindowSizeFunction());
        platformIO.setPlatformSetWindowTitle(new SetWindowTitleFunction());
        platformIO.setPlatformSetWindowFocus(new SetWindowFocusFunction());
        platformIO.setPlatformGetWindowFocus(new GetWindowFocusFunction());
        platformIO.setPlatformGetWindowMinimized(new GetWindowMinimizedFunction());
        platformIO.setPlatformSetWindowAlpha(new SetWindowAlphaFunction());
        platformIO.setPlatformRenderWindow(new RenderWindowFunction());
        platformIO.setPlatformSwapBuffers(new SwapBuffersFunction());
        ImGuiViewport mainViewport = ImGui.getMainViewport();
        ImGuiViewportDataGlfw data = new ImGuiViewportDataGlfw();
        data.window = this.mainWindowPtr;
        data.windowOwned = false;
        mainViewport.setPlatformUserData(data);
    }

    public static enum MouseHandledBy {
        EDITOR_GRABBED,
        IMGUI,
        GAME,
        BOTH;


        public boolean allowImgui() {
            return this == IMGUI || this == BOTH;
        }

        public boolean allowGame() {
            return this == GAME || this == BOTH;
        }
    }

    private static final class ImGuiViewportDataGlfw {
        long window;
        boolean windowOwned = false;
        int ignoreWindowPosEventFrame = -1;
        int ignoreWindowSizeEventFrame = -1;

        private ImGuiViewportDataGlfw() {
        }
    }

    private final class CreateWindowFunction
    extends ImPlatformFuncViewport {
        private CreateWindowFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp) {
            ImGuiViewportDataGlfw data = new ImGuiViewportDataGlfw();
            vp.setPlatformUserData(data);
            GLFW.glfwWindowHint((int)131076, (int)0);
            GLFW.glfwWindowHint((int)131073, (int)0);
            if (CustomImGuiImplGlfw.this.glfwHasFocusOnShow) {
                GLFW.glfwWindowHint((int)131084, (int)0);
            }
            GLFW.glfwWindowHint((int)131077, (int)(vp.hasFlags(8) ? 0 : 1));
            if (CustomImGuiImplGlfw.this.glfwHawWindowTopmost) {
                GLFW.glfwWindowHint((int)131079, (int)(vp.hasFlags(512) ? 1 : 0));
            }
            data.window = GLFW.glfwCreateWindow((int)((int)vp.getSizeX()), (int)((int)vp.getSizeY()), (CharSequence)"No Title Yet", (long)0L, (long)CustomImGuiImplGlfw.this.mainWindowPtr);
            data.windowOwned = true;
            vp.setPlatformHandle(data.window);
            if (IS_WINDOWS) {
                vp.setPlatformHandleRaw(GLFWNativeWin32.glfwGetWin32Window((long)data.window));
            }
            GLFW.glfwSetWindowPos((long)data.window, (int)((int)vp.getPosX()), (int)((int)vp.getPosY()));
            GLFW.glfwSetMouseButtonCallback((long)data.window, CustomImGuiImplGlfw.this::mouseButtonCallback);
            GLFW.glfwSetScrollCallback((long)data.window, CustomImGuiImplGlfw.this::scrollCallback);
            GLFW.glfwSetKeyCallback((long)data.window, CustomImGuiImplGlfw.this::keyCallback);
            GLFW.glfwSetCharModsCallback((long)data.window, CustomImGuiImplGlfw.this::charCallback);
            GLFW.glfwSetWindowCloseCallback((long)data.window, CustomImGuiImplGlfw.this::windowCloseCallback);
            GLFW.glfwSetWindowPosCallback((long)data.window, CustomImGuiImplGlfw.this::windowPosCallback);
            GLFW.glfwSetWindowSizeCallback((long)data.window, CustomImGuiImplGlfw.this::windowSizeCallback);
            GLFW.glfwMakeContextCurrent((long)data.window);
            GLFW.glfwSwapInterval((int)0);
        }
    }

    private final class DestroyWindowFunction
    extends ImPlatformFuncViewport {
        private DestroyWindowFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            if (data != null && data.windowOwned) {
                for (int i = 0; i < CustomImGuiImplGlfw.this.keyOwnerWindows.length; ++i) {
                    if (CustomImGuiImplGlfw.this.keyOwnerWindows[i] != data.window) continue;
                    CustomImGuiImplGlfw.this.keyCallback(data.window, i, 0, 0, 0);
                }
                GLFW.glfwDestroyWindow((long)data.window);
            }
            vp.setPlatformUserData(null);
            vp.setPlatformHandle(0L);
        }
    }

    private final class ShowWindowFunction
    extends ImPlatformFuncViewport {
        private ShowWindowFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            if (IS_WINDOWS && vp.hasFlags(16)) {
                ImGuiImplGlfwNative.win32hideFromTaskBar(vp.getPlatformHandleRaw());
            }
            if (!CustomImGuiImplGlfw.this.viewportWindowsHidden) {
                GLFW.glfwShowWindow((long)data.window);
            }
        }
    }

    private static final class GetWindowPosFunction
    extends ImPlatformFuncViewportSuppImVec2 {
        private final int[] posX = new int[1];
        private final int[] posY = new int[1];

        private GetWindowPosFunction() {
        }

        @Override
        public void get(ImGuiViewport vp, ImVec2 dstImVec2) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            GLFW.glfwGetWindowPos((long)data.window, (int[])this.posX, (int[])this.posY);
            dstImVec2.x = this.posX[0];
            dstImVec2.y = this.posY[0];
        }
    }

    private static final class SetWindowPosFunction
    extends ImPlatformFuncViewportImVec2 {
        private SetWindowPosFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp, ImVec2 imVec2) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            data.ignoreWindowPosEventFrame = ImGui.getFrameCount();
            GLFW.glfwSetWindowPos((long)data.window, (int)((int)imVec2.x), (int)((int)imVec2.y));
        }
    }

    private static final class GetWindowSizeFunction
    extends ImPlatformFuncViewportSuppImVec2 {
        private final int[] width = new int[1];
        private final int[] height = new int[1];

        private GetWindowSizeFunction() {
        }

        @Override
        public void get(ImGuiViewport vp, ImVec2 dstImVec2) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            GLFW.glfwGetWindowSize((long)data.window, (int[])this.width, (int[])this.height);
            dstImVec2.x = this.width[0];
            dstImVec2.y = this.height[0];
        }
    }

    private final class SetWindowSizeFunction
    extends ImPlatformFuncViewportImVec2 {
        private final int[] x = new int[1];
        private final int[] y = new int[1];
        private final int[] width = new int[1];
        private final int[] height = new int[1];

        private SetWindowSizeFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp, ImVec2 imVec2) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            if (IS_APPLE && !CustomImGuiImplGlfw.this.glfwHasOsxWindowPosFix) {
                GLFW.glfwGetWindowPos((long)data.window, (int[])this.x, (int[])this.y);
                GLFW.glfwGetWindowSize((long)data.window, (int[])this.width, (int[])this.height);
                GLFW.glfwSetWindowPos((long)data.window, (int)this.x[0], (int)(this.y[0] - this.height[0] + (int)imVec2.y));
            }
            data.ignoreWindowSizeEventFrame = ImGui.getFrameCount();
            GLFW.glfwSetWindowSize((long)data.window, (int)((int)imVec2.x), (int)((int)imVec2.y));
        }
    }

    private static final class SetWindowTitleFunction
    extends ImPlatformFuncViewportString {
        private SetWindowTitleFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp, String str) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            GLFW.glfwSetWindowTitle((long)data.window, (CharSequence)str);
        }
    }

    private final class SetWindowFocusFunction
    extends ImPlatformFuncViewport {
        private SetWindowFocusFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp) {
            if (CustomImGuiImplGlfw.this.glfwHasFocusWindow) {
                ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
                GLFW.glfwFocusWindow((long)data.window);
            }
        }
    }

    private static final class GetWindowFocusFunction
    extends ImPlatformFuncViewportSuppBoolean {
        private GetWindowFocusFunction() {
        }

        @Override
        public boolean get(ImGuiViewport vp) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            return GLFW.glfwGetWindowAttrib((long)data.window, (int)131073) != 0;
        }
    }

    private static final class GetWindowMinimizedFunction
    extends ImPlatformFuncViewportSuppBoolean {
        private GetWindowMinimizedFunction() {
        }

        @Override
        public boolean get(ImGuiViewport vp) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            return GLFW.glfwGetWindowAttrib((long)data.window, (int)131074) != 0;
        }
    }

    private final class SetWindowAlphaFunction
    extends ImPlatformFuncViewportFloat {
        private SetWindowAlphaFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp, float f) {
            if (CustomImGuiImplGlfw.this.glfwHasWindowAlpha) {
                ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
                GLFW.glfwSetWindowOpacity((long)data.window, (float)f);
            }
        }
    }

    private static final class RenderWindowFunction
    extends ImPlatformFuncViewport {
        private RenderWindowFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            GLFW.glfwMakeContextCurrent((long)data.window);
        }
    }

    private static final class SwapBuffersFunction
    extends ImPlatformFuncViewport {
        private SwapBuffersFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            GLFW.glfwMakeContextCurrent((long)data.window);
            GLFW.glfwSwapBuffers((long)data.window);
        }
    }
}

