/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.exporting;

import com.moulberry.flashback.Flashback;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import net.minecraft.class_1071;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_742;

public class PerfectFrames {
    private static boolean isEnabled = false;
    static List<Consumer<Boolean>> frexFlawlessFrames = new ArrayList<Consumer<Boolean>>();
    private static final Set<UUID> ignoreSkinLoading = new HashSet<UUID>();

    public static void enable() {
        isEnabled = true;
        ignoreSkinLoading.clear();
        for (Consumer<Boolean> frexFlawlessFramesConsumer : frexFlawlessFrames) {
            frexFlawlessFramesConsumer.accept(true);
        }
    }

    public static void disable() {
        isEnabled = false;
        ignoreSkinLoading.clear();
        for (Consumer<Boolean> frexFlawlessFramesConsumer : frexFlawlessFrames) {
            frexFlawlessFramesConsumer.accept(false);
        }
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static void waitUntilFrameReady() {
        long start = System.currentTimeMillis();
        while (!PerfectFrames.isFrameReady(start)) {
            LockSupport.parkNanos("waiting for frame to be ready", 100000L);
            while (class_310.method_1551().method_16075()) {
            }
        }
    }

    private static boolean isFrameReady(long start) {
        block4: {
            long current = System.currentTimeMillis();
            boolean forceFrameReady = current - start > 15000L;
            class_638 level = class_310.method_1551().field_1687;
            class_1071 skinManager = class_310.method_1551().method_1582();
            if (level == null) break block4;
            if (forceFrameReady) {
                Flashback.LOGGER.error("Waiting for skin loading took too long, ignoring...");
                for (class_742 player : level.method_18456()) {
                    class_640 playerInfo;
                    if (player == class_310.method_1551().field_1724 || (playerInfo = player.method_3123()) == null || skinManager.method_52863(playerInfo.method_2966()).isDone()) continue;
                    Flashback.LOGGER.error("Took too long to load skin for {}", (Object)player.method_5667());
                    ignoreSkinLoading.add(player.method_5667());
                }
            } else {
                for (class_742 player : level.method_18456()) {
                    class_640 playerInfo;
                    if (player == class_310.method_1551().field_1724 || ignoreSkinLoading.contains(player.method_5667()) || (playerInfo = player.method_3123()) == null || skinManager.method_52863(playerInfo.method_2966()).isDone()) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

