/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.io;

import com.moulberry.flashback.CachedChunkPacket;
import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.SneakyThrow;
import com.moulberry.flashback.TempFolderProvider;
import com.moulberry.flashback.action.ActionConfigurationPacket;
import com.moulberry.flashback.action.ActionGamePacket;
import com.moulberry.flashback.action.ActionLevelChunkCached;
import com.moulberry.flashback.io.ReplayWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2658;
import net.minecraft.class_2672;
import net.minecraft.class_5455;
import net.minecraft.class_8732;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class AsyncReplaySaver {
    private final ArrayBlockingQueue<Consumer<ReplayWriter>> tasks = new ArrayBlockingQueue(1024);
    private final AtomicReference<Throwable> error = new AtomicReference<Object>(null);
    private final AtomicBoolean shouldStop = new AtomicBoolean(false);
    private final AtomicBoolean hasStopped = new AtomicBoolean(false);
    private final Path recordFolder;
    private final Int2ObjectMap<List<CachedChunkPacket>> cachedChunkPackets = new Int2ObjectOpenHashMap();
    private int totalWrittenChunkPackets = 0;

    public AsyncReplaySaver(class_5455 registryAccess) {
        this.recordFolder = TempFolderProvider.createTemp(TempFolderProvider.TempFolderType.RECORDING, UUID.randomUUID());
        ReplayWriter replayWriter = new ReplayWriter(registryAccess);
        new Thread(() -> {
            try {
                while (true) {
                    Consumer<ReplayWriter> task;
                    if ((task = this.tasks.poll(10L, TimeUnit.MILLISECONDS)) == null) {
                        if (!this.shouldStop.get()) continue;
                        this.hasStopped.set(true);
                        return;
                    }
                    task.accept(replayWriter);
                }
            }
            catch (Throwable t) {
                this.error.set(t);
                this.hasStopped.set(true);
                return;
            }
        }).start();
    }

    public void submit(Consumer<ReplayWriter> consumer) {
        this.checkForError();
        if (this.hasStopped.get()) {
            throw new IllegalStateException("Cannot submit task to AsyncReplayWriter that has already stopped");
        }
        while (true) {
            try {
                this.tasks.put(consumer);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void writeGamePackets(class_9139<ByteBuf, class_2596<? super class_2602>> gamePacketCodec, List<class_2596<? super class_2602>> packets) {
        ArrayList<class_2596<? super class_2602>> packetCopy = new ArrayList<class_2596<? super class_2602>>(packets);
        this.submit(writer -> {
            class_9129 chunkCacheOutput = null;
            int lastChunkCacheIndex = -1;
            class_9129 customPayloadTempBuffer = null;
            for (class_2596 packet : packetCopy) {
                if (packet instanceof class_2672) {
                    class_2672 levelChunkPacket = (class_2672)packet;
                    int index = -1;
                    CachedChunkPacket cachedChunkPacket = new CachedChunkPacket(levelChunkPacket, -1);
                    int hashCode = cachedChunkPacket.hashCode();
                    boolean add = true;
                    ArrayList<CachedChunkPacket> cached = (ArrayList<CachedChunkPacket>)this.cachedChunkPackets.get(hashCode);
                    if (cached == null) {
                        cached = new ArrayList<CachedChunkPacket>();
                        this.cachedChunkPackets.put(hashCode, cached);
                    } else {
                        for (CachedChunkPacket existingChunkPacket : cached) {
                            if (!existingChunkPacket.equals(cachedChunkPacket)) continue;
                            add = false;
                            index = existingChunkPacket.index;
                            break;
                        }
                    }
                    if (add) {
                        index = this.totalWrittenChunkPackets++;
                        int cacheIndex = index / 10000;
                        if (lastChunkCacheIndex >= 0 && cacheIndex != lastChunkCacheIndex) {
                            this.writeChunkCacheFile(chunkCacheOutput, lastChunkCacheIndex);
                            chunkCacheOutput = null;
                        }
                        lastChunkCacheIndex = cacheIndex;
                        if (chunkCacheOutput == null) {
                            chunkCacheOutput = new class_9129(Unpooled.buffer(), writer.registryAccess());
                        }
                        int startWriterIndex = chunkCacheOutput.writerIndex();
                        chunkCacheOutput.method_53002(-1);
                        gamePacketCodec.encode((Object)chunkCacheOutput, (Object)packet);
                        int endWriterIndex = chunkCacheOutput.writerIndex();
                        int size = endWriterIndex - startWriterIndex - 4;
                        chunkCacheOutput.method_52990(startWriterIndex);
                        chunkCacheOutput.method_53002(size);
                        chunkCacheOutput.method_52990(endWriterIndex);
                        cachedChunkPacket.index = index;
                        cached.add(cachedChunkPacket);
                    }
                    writer.startAction(ActionLevelChunkCached.INSTANCE);
                    writer.friendlyByteBuf().method_10804(index);
                    writer.finishAction(ActionLevelChunkCached.INSTANCE);
                    continue;
                }
                if (packet instanceof class_2658) {
                    try {
                        if (customPayloadTempBuffer == null) {
                            customPayloadTempBuffer = new class_9129(Unpooled.buffer(), writer.registryAccess());
                        }
                        customPayloadTempBuffer.method_52931();
                        gamePacketCodec.encode((Object)customPayloadTempBuffer, (Object)packet);
                        writer.startAction(ActionGamePacket.INSTANCE);
                        writer.friendlyByteBuf().method_52975((ByteBuf)customPayloadTempBuffer);
                        writer.finishAction(ActionGamePacket.INSTANCE);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                writer.startAction(ActionGamePacket.INSTANCE);
                gamePacketCodec.encode((Object)writer.friendlyByteBuf(), (Object)packet);
                writer.finishAction(ActionGamePacket.INSTANCE);
            }
            if (lastChunkCacheIndex >= 0) {
                this.writeChunkCacheFile(chunkCacheOutput, lastChunkCacheIndex);
            }
        });
    }

    private void writeChunkCacheFile(class_9129 chunkCacheOutput, int index) {
        if (chunkCacheOutput == null || chunkCacheOutput.writerIndex() == 0) {
            return;
        }
        try {
            byte[] bytes = new byte[chunkCacheOutput.writerIndex()];
            chunkCacheOutput.method_52952(0, bytes);
            Path levelChunkCachePath = this.recordFolder.resolve("level_chunk_caches").resolve("" + index);
            Files.createDirectories(levelChunkCachePath.getParent(), new FileAttribute[0]);
            Files.write(levelChunkCachePath, bytes, StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.SYNC);
        }
        catch (IOException e) {
            SneakyThrow.sneakyThrow(e);
        }
    }

    public void writeConfigurationPackets(class_9139<ByteBuf, class_2596<? super class_8732>> configurationPacketCodec, List<class_2596<? super class_8732>> packets) {
        ArrayList<class_2596<? super class_8732>> packetCopy = new ArrayList<class_2596<? super class_8732>>(packets);
        this.submit(writer -> {
            for (class_2596 packet : packetCopy) {
                writer.startAction(ActionConfigurationPacket.INSTANCE);
                configurationPacketCodec.encode((Object)writer.friendlyByteBuf(), (Object)packet);
                writer.finishAction(ActionConfigurationPacket.INSTANCE);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIcon(class_1011 nativeImage) {
        int width = nativeImage.method_4307();
        int height = nativeImage.method_4323();
        int x = 0;
        int y = 0;
        if (width > height) {
            x = (width - height) / 2;
            width = height;
        } else {
            y = (height - width) / 2;
            height = width;
        }
        try (class_1011 scaledImage = new class_1011(64, 64, false);){
            nativeImage.method_4300(x, y, width, height, scaledImage);
            scaledImage.method_4314(this.recordFolder.resolve("icon.png"));
        }
        catch (IOException e) {
            Flashback.LOGGER.warn("Couldn't save screenshot", (Throwable)e);
        }
        finally {
            nativeImage.close();
        }
    }

    public void writeReplayChunk(String chunkName, String metadata) {
        this.submit(writer -> {
            try {
                Path chunkFile = this.recordFolder.resolve(chunkName);
                Files.write(chunkFile, writer.popBytes(), new OpenOption[0]);
                Path metaFile = this.recordFolder.resolve("metadata.json");
                if (Files.exists(metaFile, new LinkOption[0])) {
                    Files.move(metaFile, this.recordFolder.resolve("metadata.json.old"), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                }
                Files.writeString(metaFile, (CharSequence)metadata, new OpenOption[0]);
            }
            catch (IOException e) {
                SneakyThrow.sneakyThrow(e);
            }
        });
    }

    private void waitForTasks() {
        this.checkForError();
        if (this.hasStopped.get()) {
            throw new IllegalStateException("Cannot wait for tasks on AsyncReplayWriter that has already stopped");
        }
        while (!this.tasks.isEmpty()) {
            this.checkForError();
            LockSupport.parkNanos("waiting for async replay writer to finish tasks", 100000L);
        }
    }

    public Path finish() {
        this.waitForTasks();
        this.shouldStop.set(true);
        while (!this.hasStopped.get()) {
            this.checkForError();
            LockSupport.parkNanos("waiting for async replay writer to stop", 100000L);
        }
        this.checkForError();
        return this.recordFolder;
    }

    private void checkForError() {
        Throwable t = this.error.get();
        if (t != null) {
            SneakyThrow.sneakyThrow(t);
        }
    }
}

