/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.io;

import com.moulberry.flashback.action.Action;
import com.moulberry.flashback.action.ActionRegistry;
import com.moulberry.flashback.playback.ReplayServer;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_9129;

public class ReplayReader {
    private final class_2540 friendlyByteBuf;
    private final int replaySnapshotOffset;
    private final int replayActionsOffset;
    private class_5455 registryAccess;
    private class_2960 lastActionName = null;
    private final Int2ObjectMap<Action> actions = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<class_2960> ignoredActions = new Int2ObjectOpenHashMap();

    public ReplayReader(ByteBuf byteBuf, class_5455 registryAccess) {
        this.friendlyByteBuf = new class_2540(byteBuf);
        this.registryAccess = registryAccess;
        int magic = this.friendlyByteBuf.readInt();
        if (magic != -679417724) {
            throw new RuntimeException("Invalid magic");
        }
        int actions = this.friendlyByteBuf.method_10816();
        for (int i = 0; i < actions; ++i) {
            class_2960 actionName = this.friendlyByteBuf.method_10810();
            Action action = ActionRegistry.getAction(actionName);
            if (action == null) {
                if (actionName.method_12832().endsWith("optional")) {
                    this.ignoredActions.put(i, (Object)actionName);
                    continue;
                }
                throw new RuntimeException("Missing action: " + String.valueOf(actionName));
            }
            this.actions.put(i, (Object)action);
        }
        int snapshotSize = this.friendlyByteBuf.readInt();
        if (snapshotSize < 0) {
            throw new RuntimeException("Invalid snapshot size: " + snapshotSize + " (0x" + Integer.toHexString(snapshotSize) + ")");
        }
        this.replaySnapshotOffset = this.friendlyByteBuf.readerIndex();
        this.friendlyByteBuf.method_52994(snapshotSize);
        this.replayActionsOffset = this.friendlyByteBuf.readerIndex();
    }

    public void changeRegistryAccess(class_5455 registryAccess) {
        this.registryAccess = registryAccess;
    }

    public void resetToStart() {
        this.friendlyByteBuf.method_52988(this.replayActionsOffset);
    }

    public void handleSnapshot(ReplayServer replayServer) {
        this.friendlyByteBuf.method_52988(this.replaySnapshotOffset);
        replayServer.isProcessingSnapshot = true;
        while (this.friendlyByteBuf.readerIndex() < this.replayActionsOffset) {
            int size;
            int id = this.friendlyByteBuf.method_10816();
            Action action = (Action)this.actions.get(id);
            if (action == null) {
                if (this.ignoredActions.containsKey(id)) {
                    this.lastActionName = (class_2960)this.ignoredActions.get(id);
                    size = this.friendlyByteBuf.readInt();
                    this.friendlyByteBuf.method_52994(size);
                    continue;
                }
                throw new RuntimeException("Unknown action id: " + id + ". Last action was " + String.valueOf(this.lastActionName));
            }
            this.lastActionName = action.name();
            size = this.friendlyByteBuf.readInt();
            ByteBuf slice = this.friendlyByteBuf.readSlice(size);
            class_9129 registryFriendlyByteBuf = new class_9129(slice, this.registryAccess);
            action.handle(replayServer, registryFriendlyByteBuf);
            if (slice.readerIndex() >= slice.writerIndex()) continue;
            throw new RuntimeException("Action " + String.valueOf(this.lastActionName) + " failed to fully read. Had " + slice.writerIndex() + " bytes available, only read " + slice.readerIndex());
        }
        replayServer.isProcessingSnapshot = false;
    }

    public boolean handleNextAction(ReplayServer replayServer) {
        int id;
        Action action;
        if (this.friendlyByteBuf.readerIndex() >= this.friendlyByteBuf.writerIndex()) {
            return false;
        }
        if (this.friendlyByteBuf.readerIndex() < this.replayActionsOffset) {
            this.friendlyByteBuf.method_52988(this.replayActionsOffset);
        }
        if ((action = (Action)this.actions.get(id = this.friendlyByteBuf.method_10816())) == null) {
            if (this.ignoredActions.containsKey(id)) {
                this.lastActionName = (class_2960)this.ignoredActions.get(id);
                int size = this.friendlyByteBuf.readInt();
                this.friendlyByteBuf.method_52994(size);
                return true;
            }
            throw new RuntimeException("Unknown action id: " + id + ". Last action was " + String.valueOf(this.lastActionName));
        }
        this.lastActionName = action.name();
        int size = this.friendlyByteBuf.readInt();
        ByteBuf slice = this.friendlyByteBuf.readSlice(size);
        class_9129 registryFriendlyByteBuf = new class_9129(slice, this.registryAccess);
        action.handle(replayServer, registryFriendlyByteBuf);
        if (slice.readerIndex() < slice.writerIndex()) {
            throw new RuntimeException("Action " + String.valueOf(this.lastActionName) + " failed to fully read. Had " + slice.writerIndex() + " bytes available, only read " + slice.readerIndex());
        }
        return true;
    }
}

