/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.playback;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Lifecycle;
import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.exception.UnsupportedPacketException;
import com.moulberry.flashback.playback.EmptyLevelSource;
import com.moulberry.flashback.playback.ReplayServer;
import com.moulberry.flashback.registry.RegistryHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2661;
import net.minecraft.class_2670;
import net.minecraft.class_2720;
import net.minecraft.class_2790;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3283;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5912;
import net.minecraft.class_6373;
import net.minecraft.class_6864;
import net.minecraft.class_6880;
import net.minecraft.class_7655;
import net.minecraft.class_7659;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7780;
import net.minecraft.class_7782;
import net.minecraft.class_7832;
import net.minecraft.class_7924;
import net.minecraft.class_8605;
import net.minecraft.class_8611;
import net.minecraft.class_8732;
import net.minecraft.class_8733;
import net.minecraft.class_8734;
import net.minecraft.class_9053;
import net.minecraft.class_9088;
import net.minecraft.class_9150;
import net.minecraft.class_9151;
import net.minecraft.class_9223;
import net.minecraft.class_9224;
import net.minecraft.class_9226;
import net.minecraft.class_9248;
import net.minecraft.class_9250;
import net.minecraft.class_9448;
import net.minecraft.class_9812;
import net.minecraft.class_9814;
import net.minecraft.class_9815;

public class ReplayConfigurationPacketHandler
implements class_8732 {
    private final ReplayServer replayServer;
    private Map<class_5321<? extends class_2378<?>>, List<class_7782.class_9176>> pendingRegistryMap = null;
    private Map<class_5321<? extends class_2378<?>>, class_6864.class_5748> pendingTags = null;
    private class_7699 pendingFeatureFlags = null;
    private List<class_9226> pendingKnownPacks = null;
    private boolean pendingResetChat = false;
    private boolean dirty = false;
    public static ThreadLocal<Boolean> LENIENT_REGISTRY_LOADING = new ThreadLocal();

    public ReplayConfigurationPacketHandler(ReplayServer replayServer) {
        this.replayServer = replayServer;
    }

    public void flushPendingConfiguration() {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        boolean sendTags = false;
        ArrayList<class_8605> configurationTasks = new ArrayList<class_8605>();
        class_7699 currentFeatureFlags = this.replayServer.field_24372.method_45560();
        List<class_9226> currentKnownPacks = this.replayServer.method_34864().method_29213().flatMap(packResources -> packResources.method_56926().comp_2332().stream()).toList();
        boolean synchronizeRegistries = false;
        ArrayList<class_2596<? super class_8732>> initialPackets = new ArrayList<class_2596<? super class_8732>>();
        if (this.pendingFeatureFlags != null) {
            if (!currentFeatureFlags.equals((Object)this.pendingFeatureFlags)) {
                currentFeatureFlags = this.pendingFeatureFlags;
                initialPackets.add((class_2596<? super class_8732>)new class_7832(class_7701.field_40180.method_45392(this.pendingFeatureFlags)));
            }
            this.pendingFeatureFlags = null;
        }
        if (this.pendingResetChat) {
            initialPackets.add((class_2596<? super class_8732>)class_9448.field_50083);
            this.pendingResetChat = false;
        }
        if (this.pendingKnownPacks != null) {
            HashSet currentSet = new HashSet(currentKnownPacks);
            HashSet<class_9226> pendingSet = new HashSet<class_9226>(this.pendingKnownPacks);
            if (!currentSet.equals(pendingSet)) {
                currentKnownPacks = this.pendingKnownPacks;
                synchronizeRegistries = true;
            }
            this.pendingKnownPacks = null;
        }
        if (this.pendingRegistryMap != null && !this.pendingRegistryMap.isEmpty()) {
            synchronizeRegistries |= this.tryUpdateRegistries();
        }
        if (this.pendingTags != null && !this.pendingTags.isEmpty()) {
            this.pendingTags.forEach((resourceKey, networkPayload) -> networkPayload.method_56532(this.replayServer.method_30611().method_30530(resourceKey)));
            sendTags = true;
            this.pendingTags = null;
        }
        if (synchronizeRegistries) {
            configurationTasks.add((class_8605)new class_9223(currentKnownPacks, this.replayServer.field_25132));
        } else if (sendTags) {
            this.replayServer.method_3760().method_14581((class_2596)new class_2790(class_6864.method_40105((class_7780)this.replayServer.field_25132)));
        }
        if (initialPackets.isEmpty() && configurationTasks.isEmpty()) {
            return;
        }
        configurationTasks.add((class_8605)new class_8611());
        Collection<String> selectedPacks = ReplayConfigurationPacketHandler.knownPacksToIds(this.replayServer.method_3836(), currentKnownPacks);
        this.replayServer.updateRegistry(currentFeatureFlags, selectedPacks, initialPackets, configurationTasks);
        for (class_3222 player : new ArrayList(this.replayServer.method_3760().method_14571())) {
            player.method_31472();
        }
        for (class_3218 value : this.replayServer.field_4589.values()) {
            this.replayServer.closeLevel(value);
        }
        this.replayServer.field_4589.clear();
        this.replayServer.method_3735();
    }

    private static Collection<String> knownPacksToIds(class_3283 packRepository, Collection<class_9226> knownPacks) {
        ArrayList<String> selectedPacks = new ArrayList<String>();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        packRepository.method_14441().forEach(pack -> {
            class_9224 packLocationInfo = pack.method_56933();
            packLocationInfo.comp_2332().ifPresent(knownPack -> builder.put(knownPack, (Object)packLocationInfo.comp_2329()));
        });
        ImmutableMap knownPackToId = builder.build();
        for (class_9226 knownPack : knownPacks) {
            String selectedId = (String)knownPackToId.get(knownPack);
            if (selectedId == null) continue;
            selectedPacks.add(selectedId);
        }
        return selectedPacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryUpdateRegistries() {
        boolean hasRegistriesChanged;
        class_5455.class_6890 synchronizedRegistries;
        Map<class_5321<? extends class_2378<?>>, List<class_7782.class_9176>> entries = this.pendingRegistryMap;
        this.pendingRegistryMap = null;
        class_3300 resourceProvider = this.replayServer.method_34864();
        class_5455.class_6890 accessForLoading = this.replayServer.method_46221().method_45935((Object)class_7659.field_39972);
        LENIENT_REGISTRY_LOADING.set(Boolean.TRUE);
        try {
            synchronizedRegistries = class_7655.method_56519(entries, (class_5912)resourceProvider, (class_5455)accessForLoading, (List)class_7655.field_48709);
        }
        catch (Exception e) {
            this.replayServer.failedToLoadRegistryDataWarning = true;
            Flashback.LOGGER.error("Error while trying to load registry data. Skipping... this might cause other issues", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            LENIENT_REGISTRY_LOADING.set(Boolean.FALSE);
        }
        boolean bl = hasRegistriesChanged = !RegistryHelper.equals((class_5455)this.replayServer.method_30611(), (class_5455)synchronizedRegistries, class_7655.field_48709);
        if (hasRegistriesChanged) {
            class_7780 newRegistries = this.replayServer.field_25132;
            boolean replacedPreviousLayer = false;
            HashSet<class_5321> changedRegistries = new HashSet<class_5321>();
            for (class_7655.class_7657 synchronizedRegistry : class_7655.field_48709) {
                changedRegistries.add(synchronizedRegistry.comp_985());
            }
            for (class_7659 layer : class_7659.values()) {
                class_5455.class_6890 registriesForLayer = this.replayServer.field_25132.method_45928((Object)layer);
                ArrayList<class_2378> registries = new ArrayList<class_2378>();
                boolean replacedPartOfLayer = false;
                for (class_5455.class_6892 registryEntry : registriesForLayer.method_40311().toList()) {
                    Optional overriden = synchronizedRegistries.method_33310(registryEntry.comp_350());
                    if (changedRegistries.contains(registryEntry.comp_350()) && overriden.isPresent()) {
                        registries.add((class_2378)overriden.get());
                        replacedPartOfLayer = true;
                        continue;
                    }
                    if (registryEntry.comp_350() == class_7924.field_41224) {
                        try {
                            Optional dimensionsOpt = synchronizedRegistries.method_33310(class_7924.field_41241);
                            Optional biomesOpt = synchronizedRegistries.method_33310(class_7924.field_41236);
                            if (dimensionsOpt.isPresent()) {
                                class_2378 dimensions = (class_2378)dimensionsOpt.get();
                                class_6880.class_6883 plains = biomesOpt.isPresent() ? ((class_2378)biomesOpt.get()).method_40290(class_1972.field_9451) : this.replayServer.method_30611().method_46762(class_7924.field_41236).method_46747(class_1972.field_9451);
                                class_2370 mapped = new class_2370(class_7924.field_41224, Lifecycle.stable());
                                for (class_5321 key : dimensions.method_42021()) {
                                    class_5321 stemKey = class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)key.method_29177());
                                    class_5363 stem = new class_5363((class_6880)dimensions.method_40290(key), (class_2794)new EmptyLevelSource((class_6880.class_6883<class_1959>)plains));
                                    mapped.method_10272(stemKey, (Object)stem, class_9248.field_49136);
                                }
                                replacedPartOfLayer = true;
                                registries.add(mapped.method_40276());
                                continue;
                            }
                        }
                        catch (Exception ignored) {
                            registries.add(registryEntry.comp_351());
                        }
                    }
                    registries.add(registryEntry.comp_351());
                }
                if (replacedPartOfLayer) {
                    replacedPreviousLayer = true;
                    class_5455.class_6891 finalRegistries = new class_5455.class_6891(registries);
                    newRegistries = newRegistries.method_45930((Object)layer, new class_5455.class_6890[]{finalRegistries.method_40316()});
                    continue;
                }
                if (!replacedPreviousLayer) continue;
                newRegistries = newRegistries.method_45930((Object)layer, new class_5455.class_6890[]{registriesForLayer});
            }
            if (newRegistries != this.replayServer.field_25132) {
                this.replayServer.field_25132.field_40581 = newRegistries.field_40581;
                this.replayServer.field_25132.field_40582 = newRegistries.field_40582;
                ((class_5455.class_6891)this.replayServer.field_25132.field_40583).field_36471 = ((class_5455.class_6891)newRegistries.field_40583).field_36471;
                return true;
            }
        }
        return false;
    }

    public void method_52794(class_8733 clientboundFinishConfigurationPacket) {
        throw new UnsupportedPacketException((class_2596<?>)clientboundFinishConfigurationPacket);
    }

    public void method_52795(class_8734 clientboundRegistryDataPacket) {
        this.dirty = true;
        if (this.pendingRegistryMap == null) {
            this.pendingRegistryMap = new HashMap();
        }
        this.pendingRegistryMap.put(clientboundRegistryDataPacket.comp_2258(), clientboundRegistryDataPacket.comp_2259());
    }

    public void method_52796(class_7832 clientboundUpdateEnabledFeaturesPacket) {
        this.dirty = true;
        this.pendingFeatureFlags = class_7701.field_40180.method_45387((Iterable)clientboundUpdateEnabledFeaturesPacket.comp_1113());
    }

    public void method_57045(class_9250 clientboundSelectKnownPacks) {
        this.dirty = true;
        this.pendingKnownPacks = clientboundSelectKnownPacks.comp_2356();
    }

    public void method_58577(class_9448 clientboundResetChatPacket) {
        this.dirty = true;
        this.pendingResetChat = true;
    }

    public void method_52782(class_2670 clientboundKeepAlivePacket) {
        throw new UnsupportedPacketException((class_2596<?>)clientboundKeepAlivePacket);
    }

    public void method_52783(class_6373 clientboundPingPacket) {
        throw new UnsupportedPacketException((class_2596<?>)clientboundPingPacket);
    }

    public void method_52780(class_2658 clientboundCustomPayloadPacket) {
    }

    public void method_52781(class_2661 clientboundDisconnectPacket) {
        throw new UnsupportedPacketException((class_2596<?>)clientboundDisconnectPacket);
    }

    public void method_52784(class_2720 clientboundResourcePackPushPacket) {
        this.replayServer.pushRemotePack(clientboundResourcePackPushPacket.comp_2158(), clientboundResourcePackPushPacket.comp_2159(), clientboundResourcePackPushPacket.comp_2160());
    }

    public void method_55512(class_9053 clientboundResourcePackPopPacket) {
        if (clientboundResourcePackPopPacket.comp_2157().isEmpty()) {
            this.replayServer.popAllRemotePacks();
        } else {
            this.replayServer.popRemotePack((UUID)clientboundResourcePackPopPacket.comp_2157().get());
        }
    }

    public void method_11126(class_2790 clientboundUpdateTagsPacket) {
        this.dirty = true;
        if (this.pendingTags == null) {
            this.pendingTags = new HashMap();
        }
        this.pendingTags.putAll(clientboundUpdateTagsPacket.method_12000());
    }

    public void method_56149(class_9150 clientboundStoreCookiePacket) {
        throw new UnsupportedPacketException((class_2596<?>)clientboundStoreCookiePacket);
    }

    public void method_56150(class_9151 clientboundTransferPacket) {
        throw new UnsupportedPacketException((class_2596<?>)clientboundTransferPacket);
    }

    public void method_60883(class_9814 clientboundCustomReportDetailsPacket) {
        throw new UnsupportedPacketException((class_2596<?>)clientboundCustomReportDetailsPacket);
    }

    public void method_60884(class_9815 clientboundServerLinksPacket) {
        throw new UnsupportedPacketException((class_2596<?>)clientboundServerLinksPacket);
    }

    public void method_55845(class_9088 clientboundCookieRequestPacket) {
        throw new UnsupportedPacketException((class_2596<?>)clientboundCookieRequestPacket);
    }

    public void method_10839(class_9812 disconnectionDetails) {
    }

    public boolean method_48106() {
        return false;
    }
}

