/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.mt1006.mocap.command.io.CommandOutput;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.files.SceneData;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.mocap.playing.Playing;
import net.mt1006.mocap.mocap.playing.playback.Playback;

public class CommandSuggestions {
    private static final int RECORDINGS = 1;
    private static final int SCENES = 2;
    private static final int CURRENTLY_RECORDED = 4;
    private static final int PLAYABLE = 7;
    public static final Set<String> inputSet = new HashSet<String>();
    public static final Map<String, List<String>> sceneElementCache = new HashMap<String, List<String>>();

    private static CompletableFuture<Suggestions> inputSuggestions(SuggestionsBuilder builder, int suggestionFlags, boolean ignoreFirstChar) {
        String remaining = builder.getRemaining();
        for (String input : inputSet) {
            int type;
            if ((suggestionFlags & (type = (switch (input.charAt(0)) {
                case '.' -> 2;
                case '-' -> 4;
                default -> 1;
            }))) == 0 || !input.startsWith(remaining) && (!ignoreFirstChar || !input.substring(1).startsWith(remaining))) continue;
            builder.suggest(input);
        }
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> recording(CommandContext<?> ctx, SuggestionsBuilder builder) {
        return CommandSuggestions.inputSuggestions(builder, 1, false);
    }

    public static CompletableFuture<Suggestions> scene(CommandContext<?> ctx, SuggestionsBuilder builder) {
        return CommandSuggestions.inputSuggestions(builder, 2, true);
    }

    public static CompletableFuture<Suggestions> currentlyRecorded(CommandContext<?> ctx, SuggestionsBuilder builder) {
        return CommandSuggestions.inputSuggestions(builder, 4, true);
    }

    public static CompletableFuture<Suggestions> playable(CommandContext<?> ctx, SuggestionsBuilder builder) {
        return CommandSuggestions.inputSuggestions(builder, 7, false);
    }

    public static CompletableFuture<Suggestions> playbackId(CommandContext<?> ctx, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining();
        for (Playback.Root playback : Playing.playbacks) {
            String str = playback.suggestionStr;
            if (!str.startsWith(remaining)) continue;
            builder.suggest(str);
        }
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> sceneElement(CommandContext<?> ctx, SuggestionsBuilder builder) {
        Object sceneName = StringArgumentType.getString(ctx, (String)"scene_name");
        if (((String)sceneName).isEmpty()) {
            return builder.buildFuture();
        }
        if (((String)sceneName).charAt(0) != '.') {
            sceneName = "." + (String)sceneName;
        }
        if (!inputSet.contains(sceneName)) {
            return builder.buildFuture();
        }
        List<String> elements = sceneElementCache.get(sceneName);
        if (elements == null) {
            SceneData sceneData = new SceneData();
            if (!sceneData.load(CommandOutput.LOGS, (String)sceneName)) {
                builder.buildFuture();
            }
            elements = sceneData.saveToSceneElementCache((String)sceneName);
        }
        if (elements == null) {
            return builder.buildFuture();
        }
        String remaining = builder.getRemaining();
        for (String str : elements) {
            if (!str.startsWith(remaining)) continue;
            builder.suggest(str);
        }
        return builder.buildFuture();
    }

    public static void initInputSet() {
        List<String> sceneList;
        inputSet.clear();
        List<String> recordingList = RecordingFiles.list();
        if (recordingList != null) {
            inputSet.addAll(recordingList);
        }
        if ((sceneList = SceneFiles.list()) != null) {
            inputSet.addAll(sceneList);
        }
    }

    public static void clearCache() {
        CommandSuggestions.initInputSet();
        sceneElementCache.clear();
    }
}

