/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;
import org.jetbrains.annotations.Nullable;

public class CommandsContext {
    private static final Map<ServerPlayer, CommandsContext> contexts = new HashMap<ServerPlayer, CommandsContext>();
    public static int haveSyncEnabled = 0;
    public PlaybackModifiers modifiers = PlaybackModifiers.empty();
    private boolean sync = false;
    @Nullable
    public String doubleStart = null;

    public static CommandsContext get(ServerPlayer player) {
        CommandsContext ctx = contexts.get(player);
        if (ctx == null) {
            ctx = new CommandsContext();
            contexts.put(player, ctx);
        }
        return ctx;
    }

    public static void removePlayer(ServerPlayer player) {
        CommandsContext ctx = contexts.get(player);
        if (ctx == null) {
            return;
        }
        if (ctx.sync) {
            --haveSyncEnabled;
        }
        contexts.remove(player);
    }

    public static boolean hasDefaultModifiers(@Nullable ServerPlayer source) {
        return source == null || CommandsContext.get((ServerPlayer)source).modifiers.areDefault();
    }

    public static PlaybackModifiers getFinalModifiers(@Nullable ServerPlayer source, PlaybackModifiers simpleModifiers) {
        PlaybackModifiers modifiers = source != null ? CommandsContext.get((ServerPlayer)source).modifiers.copy() : PlaybackModifiers.empty();
        PlaybackModifiers mergedModifiers = simpleModifiers.mergeWithParent(modifiers);
        mergedModifiers.transformations = modifiers.transformations;
        return mergedModifiers;
    }

    public boolean setSync(boolean sync) {
        boolean oldSync = this.sync;
        this.sync = sync;
        if (oldSync != sync) {
            haveSyncEnabled = sync ? ++haveSyncEnabled : --haveSyncEnabled;
        }
        return oldSync;
    }

    public boolean getSync() {
        return this.sync;
    }
}

