/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.command.CommandsContext;
import net.mt1006.mocap.command.io.CommandInfo;
import net.mt1006.mocap.mocap.playing.Playing;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;

public class PlaybackCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> getArgumentBuilder(CommandBuildContext buildContext) {
        LiteralArgumentBuilder commandBuilder = Commands.literal((String)"playback");
        commandBuilder.then(Commands.literal((String)"start").then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::playable).executes(CommandUtils.command(PlaybackCommand::start))).then(CommandUtils.playerArguments(buildContext, CommandUtils.command(PlaybackCommand::start)))));
        commandBuilder.then(Commands.literal((String)"stop").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::playbackId).executes(CommandUtils.command(PlaybackCommand::stop))));
        commandBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"stop_all").executes(CommandUtils.command(info -> PlaybackCommand.stopAll(info, false)))).then(Commands.literal((String)"including_others").executes(CommandUtils.command(info -> PlaybackCommand.stopAll(info, true))))).then(Commands.literal((String)"excluding_others").executes(CommandUtils.command(info -> PlaybackCommand.stopAll(info, false)))));
        commandBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"modifiers").then(CommandUtils.withModifiers(buildContext, Commands.literal((String)"set"), CommandUtils.command(Playing::modifiersSet), false))).then(Commands.literal((String)"list").executes(CommandUtils.command(Playing::modifiersList)))).then(Commands.literal((String)"reset").executes(CommandUtils.command(Playing::modifiersReset)))).then(Commands.literal((String)"add_to").then(Commands.argument((String)"scene_name", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::scene).then(Commands.argument((String)"to_add", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::playable).executes(CommandUtils.command(PlaybackCommand::modifiersAddTo))))));
        commandBuilder.then(Commands.literal((String)"list").executes(CommandUtils.command(Playing::list)));
        return commandBuilder;
    }

    private static boolean start(CommandInfo commandInfo) {
        String name = commandInfo.getNullableString("name");
        if (name == null) {
            commandInfo.sendFailure("error.unable_to_get_argument", new Object[0]);
            return false;
        }
        PlaybackModifiers modifiers = commandInfo.getSimpleModifiers(commandInfo);
        if (modifiers == null) {
            return false;
        }
        try {
            PlaybackModifiers finalModifiers = CommandsContext.getFinalModifiers(commandInfo.sourcePlayer, modifiers);
            boolean hasDefaultModifiers = CommandsContext.hasDefaultModifiers(commandInfo.sourcePlayer);
            return Playing.start(commandInfo, name, finalModifiers, hasDefaultModifiers);
        }
        catch (Exception e) {
            commandInfo.sendException(e, "playback.start.error", new Object[0]);
            return false;
        }
    }

    private static boolean stop(CommandInfo commandInfo) {
        try {
            Pair<Integer, String> idPair = CommandUtils.splitIdStr(commandInfo.getString("id"));
            Playing.stop(commandInfo, (Integer)idPair.getFirst(), (String)idPair.getSecond());
            return true;
        }
        catch (IllegalArgumentException e) {
            commandInfo.sendException(e, "error.unable_to_get_argument", new Object[0]);
            return false;
        }
    }

    private static boolean stopAll(CommandInfo commandInfo, boolean includeOthers) {
        Playing.stopAll(commandInfo, includeOthers ? null : commandInfo.sourcePlayer);
        return true;
    }

    private static boolean modifiersAddTo(CommandInfo commandInfo) {
        try {
            String name = commandInfo.getString("scene_name");
            String toAdd = commandInfo.getString("to_add");
            return Playing.modifiersAddTo(commandInfo, name, toAdd);
        }
        catch (IllegalArgumentException e) {
            commandInfo.sendException(e, "error.unable_to_get_argument", new Object[0]);
            return false;
        }
    }
}

