/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.command.io.CommandInfo;
import net.mt1006.mocap.mocap.recording.Recording;
import net.mt1006.mocap.mocap.settings.Settings;

public class RecordingCommand {
    private static final Command<CommandSourceStack> COMMAND_START = CommandUtils.command(RecordingCommand::start);

    public static LiteralArgumentBuilder<CommandSourceStack> getArgumentBuilder() {
        LiteralArgumentBuilder commandBuilder = Commands.literal((String)"recording");
        commandBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"start").executes(COMMAND_START)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).executes(COMMAND_START)).then(Commands.argument((String)"instant_save", (ArgumentType)StringArgumentType.string()).executes(COMMAND_START))));
        commandBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"stop").executes(CommandUtils.command(RecordingCommand::stop))).then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::currentlyRecorded).executes(CommandUtils.command(RecordingCommand::stop))));
        commandBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"discard").executes(CommandUtils.command(RecordingCommand::discard))).then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::currentlyRecorded).executes(CommandUtils.command(RecordingCommand::discard))));
        commandBuilder.then(Commands.literal((String)"save").then(CommandUtils.withStringArgument(RecordingCommand::saveAuto, "name").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::currentlyRecorded).executes(CommandUtils.command(RecordingCommand::saveSpecific)))));
        commandBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(CommandUtils.command(RecordingCommand::list))).then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::currentlyRecorded).executes(CommandUtils.command(RecordingCommand::list))));
        return commandBuilder;
    }

    private static boolean start(CommandInfo commandInfo) {
        ServerPlayer player = null;
        String instantSave = null;
        try {
            Collection<GameProfile> gameProfiles = commandInfo.getGameProfiles("player");
            if (gameProfiles.size() == 1) {
                String nickname = gameProfiles.iterator().next().getName();
                player = commandInfo.server.getPlayerList().getPlayerByName(nickname);
            }
            if (player == null) {
                commandInfo.sendFailure("recording.start.player_not_found", new Object[0]);
                return false;
            }
            instantSave = commandInfo.getNullableString("instant_save");
        }
        catch (Exception e) {
            Entity entity = commandInfo.sourceEntity;
            if (!(entity instanceof ServerPlayer)) {
                commandInfo.sendFailure((Boolean)Settings.SHOW_TIPS.val != false ? "recording.start.player_not_specified.with_tip" : "recording.start.player_not_specified.no_tip", new Object[0]);
                return false;
            }
            player = (ServerPlayer)entity;
        }
        return Recording.start(commandInfo, player, instantSave);
    }

    private static boolean stop(CommandInfo commandInfo) {
        return Recording.stop(commandInfo, commandInfo.getNullableString("id"));
    }

    private static boolean discard(CommandInfo commandInfo) {
        return Recording.discard(commandInfo, commandInfo.getNullableString("id"));
    }

    private static boolean saveAuto(CommandInfo commandInfo, String name) {
        return Recording.save(commandInfo, null, name);
    }

    private static boolean saveSpecific(CommandInfo commandInfo) {
        String name = commandInfo.getNullableString("name");
        if (name == null) {
            commandInfo.sendFailure("error.unable_to_get_argument", new Object[0]);
            return false;
        }
        return Recording.save(commandInfo, commandInfo.getNullableString("id"), name);
    }

    private static boolean list(CommandInfo commandInfo) {
        return Recording.list(commandInfo, commandInfo.getNullableString("id"));
    }
}

