/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.command.io.CommandOutput;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.utils.Utils;

public class RecordingsCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> getArgumentBuilder() {
        LiteralArgumentBuilder commandBuilder = Commands.literal((String)"recordings");
        commandBuilder.then(Commands.literal((String)"copy").then(CommandUtils.withInputAndStringArgument(RecordingFiles::copy, (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::recording), "src_name", "dest_name")));
        commandBuilder.then(Commands.literal((String)"rename").then(CommandUtils.withInputAndStringArgument(RecordingFiles::rename, (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::recording), "old_name", "new_name")));
        commandBuilder.then(Commands.literal((String)"remove").then(CommandUtils.withInputArgument(RecordingFiles::remove, (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::recording), "name")));
        commandBuilder.then(Commands.literal((String)"info").then(CommandUtils.withInputArgument(RecordingFiles::info, (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::recording), "name")));
        commandBuilder.then(Commands.literal((String)"list").executes(CommandUtils.command(RecordingsCommand::list)));
        return commandBuilder;
    }

    public static boolean list(CommandOutput commandOutput) {
        StringBuilder recordingsListStr = new StringBuilder();
        List<String> recordingsList = RecordingFiles.list();
        if (recordingsList == null) {
            recordingsListStr.append(" ").append(Utils.stringFromComponent("list.error", new Object[0]));
        } else if (!recordingsList.isEmpty()) {
            recordingsList.forEach(name -> recordingsListStr.append(" ").append((String)name));
        } else {
            recordingsListStr.append(" ").append(Utils.stringFromComponent("list.empty", new Object[0]));
        }
        commandOutput.sendSuccess("recordings.list", new String(recordingsListStr));
        return true;
    }
}

