/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.command.io.CommandInfo;
import net.mt1006.mocap.command.io.CommandOutput;
import net.mt1006.mocap.mocap.files.SceneData;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;
import net.mt1006.mocap.mocap.playing.modifiers.StartDelay;
import net.mt1006.mocap.utils.Utils;

public class ScenesCommand {
    private static final Command<CommandSourceStack> COMMAND_ADD_TO = CommandUtils.command(ScenesCommand::addTo);

    public static LiteralArgumentBuilder<CommandSourceStack> getArgumentBuilder(CommandBuildContext buildContext) {
        LiteralArgumentBuilder commandBuilder = Commands.literal((String)"scenes");
        commandBuilder.then(Commands.literal((String)"add").then(CommandUtils.withStringArgument(SceneFiles::add, "name")));
        commandBuilder.then(Commands.literal((String)"copy").then(CommandUtils.withInputAndStringArgument(SceneFiles::copy, (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::scene), "src_name", "dest_name")));
        commandBuilder.then(Commands.literal((String)"rename").then(CommandUtils.withInputAndStringArgument(SceneFiles::rename, (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::scene), "old_name", "new_name")));
        commandBuilder.then(Commands.literal((String)"remove").then(CommandUtils.withInputArgument(SceneFiles::remove, (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::scene), "name")));
        commandBuilder.then(Commands.literal((String)"add_to").then(Commands.argument((String)"scene_name", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::scene).then(((RequiredArgumentBuilder)Commands.argument((String)"to_add", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::playable).executes(COMMAND_ADD_TO)).then(((RequiredArgumentBuilder)Commands.argument((String)"start_delay", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(COMMAND_ADD_TO)).then(CommandUtils.playerArguments(buildContext, COMMAND_ADD_TO))))));
        commandBuilder.then(Commands.literal((String)"remove_from").then(CommandUtils.withTwoInputArguments(SceneFiles::removeElement, (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::scene), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::sceneElement), "scene_name", "to_remove")));
        commandBuilder.then(Commands.literal((String)"modify").then(Commands.argument((String)"scene_name", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::scene).then(CommandUtils.withModifiers(buildContext, Commands.argument((String)"to_modify", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::sceneElement), CommandUtils.command(ScenesCommand::modify), true))));
        commandBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"info").then((ArgumentBuilder)CommandUtils.withStringArgument(SceneFiles::info, "scene_name").suggests(CommandSuggestions::scene))).then(CommandUtils.withTwoInputArguments(SceneFiles::elementInfo, (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::scene), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::sceneElement), "scene_name", "element_pos")));
        commandBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(CommandUtils.command(ScenesCommand::list))).then(CommandUtils.withInputArgument(SceneFiles::listElements, (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CommandSuggestions::scene), "scene_name")));
        return commandBuilder;
    }

    private static boolean addTo(CommandInfo commandInfo) {
        try {
            String name = commandInfo.getString("scene_name");
            String toAdd = commandInfo.getString("to_add");
            double delay = 0.0;
            try {
                delay = commandInfo.getDouble("start_delay");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            PlaybackModifiers modifiers = commandInfo.getSimpleModifiers(commandInfo);
            if (modifiers == null) {
                return false;
            }
            modifiers.startDelay = StartDelay.fromSeconds(delay);
            SceneData.Subscene subscene = new SceneData.Subscene(toAdd, modifiers);
            return SceneFiles.addElement(commandInfo, name, subscene);
        }
        catch (IllegalArgumentException e) {
            commandInfo.sendException(e, "error.unable_to_get_argument", new Object[0]);
            return false;
        }
    }

    private static boolean modify(CommandInfo commandInfo) {
        try {
            String name = commandInfo.getString("scene_name");
            Pair<Integer, String> posPair = CommandUtils.splitIdStr(commandInfo.getString("to_modify"));
            return SceneFiles.modify(commandInfo, name, (Integer)posPair.getFirst(), (String)posPair.getSecond());
        }
        catch (IllegalArgumentException e) {
            commandInfo.sendException(e, "error.unable_to_get_argument", new Object[0]);
            return false;
        }
    }

    public static boolean list(CommandOutput commandOutput) {
        StringBuilder scenesListStr = new StringBuilder();
        List<String> scenesList = SceneFiles.list();
        if (scenesList == null) {
            scenesListStr.append(" ").append(Utils.stringFromComponent("list.error", new Object[0]));
        } else if (!scenesList.isEmpty()) {
            scenesList.forEach(name -> scenesListStr.append(" ").append((String)name));
        } else {
            scenesListStr.append(" ").append(Utils.stringFromComponent("list.empty", new Object[0]));
        }
        commandOutput.sendSuccess("scenes.list", new String(scenesListStr));
        return true;
    }
}

