/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command.io;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.command.io.CommandOutput;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;
import net.mt1006.mocap.mocap.playing.modifiers.PlayerAsEntity;
import net.mt1006.mocap.mocap.playing.modifiers.PlayerSkin;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class CommandInfo
implements CommandOutput {
    public final CommandContext<CommandSourceStack> ctx;
    public final CommandSourceStack source;
    public final MinecraftServer server;
    public final ServerLevel level;
    @Nullable
    public final ServerPlayer sourcePlayer;
    @Nullable
    public final Entity sourceEntity;

    public CommandInfo(CommandContext<CommandSourceStack> ctx) {
        this.ctx = ctx;
        this.source = (CommandSourceStack)ctx.getSource();
        this.server = this.source.getServer();
        this.level = this.source.getLevel();
        this.sourcePlayer = this.source.getPlayer();
        this.sourceEntity = this.source.getEntity();
    }

    @Override
    public void sendSuccess(String component, Object ... args) {
        this.source.sendSuccess(() -> this.getTranslatableComponent(component, args), false);
    }

    @Override
    public void sendSuccessLiteral(String format, Object ... args) {
        this.source.sendSuccess(() -> Component.literal((String)String.format(format, args)), false);
    }

    @Override
    public void sendSuccessComponent(Component component) {
        this.source.sendSuccess(() -> component, false);
    }

    @Override
    public void sendFailure(String component, Object ... args) {
        this.source.sendFailure((Component)this.getTranslatableComponent(component, args));
    }

    @Override
    public void sendFailureWithTip(String component, Object ... args) {
        this.source.sendFailure((Component)this.getTranslatableComponent(component, args));
        if (((Boolean)Settings.SHOW_TIPS.val).booleanValue()) {
            this.source.sendFailure((Component)this.getTranslatableComponent(component + ".tip", new Object[0]));
        }
    }

    @Override
    public void sendException(Exception exception, String component, Object ... args) {
        this.sendFailure(component, args);
        Utils.exception(exception, Utils.stringFromComponent(component, args));
    }

    public MutableComponent getTranslatableComponent(String component, Object ... args) {
        return Utils.getTranslatableComponent(this.source.getEntity(), component, args);
    }

    @Nullable
    public CommandInfo getFinalCommandInfo() {
        CommandContext tempCtx = this.ctx;
        do {
            String command;
            if ((command = CommandUtils.getNode(tempCtx.getNodes(), 0)) == null || !command.equals("mocap") && !command.equals("mocap:mocap")) continue;
            return new CommandInfo((CommandContext<CommandSourceStack>)tempCtx);
        } while ((tempCtx = this.ctx.getChild()) != null);
        return null;
    }

    @Nullable
    public String getNode(int pos) {
        return CommandUtils.getNode(this.ctx.getNodes(), pos);
    }

    public int getInteger(String name) {
        return IntegerArgumentType.getInteger(this.ctx, (String)name);
    }

    public double getDouble(String name) {
        return DoubleArgumentType.getDouble(this.ctx, (String)name);
    }

    public boolean getBool(String name) {
        return BoolArgumentType.getBool(this.ctx, (String)name);
    }

    public String getString(String name) {
        return StringArgumentType.getString(this.ctx, (String)name);
    }

    public Collection<GameProfile> getGameProfiles(String name) throws CommandSyntaxException {
        return GameProfileArgument.getGameProfiles(this.ctx, (String)name);
    }

    @Nullable
    public String getNullableString(String name) {
        try {
            return StringArgumentType.getString(this.ctx, (String)name);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public PlayerSkin getPlayerSkin() {
        String fromPlayer = this.getNullableString("skin_player_name");
        if (fromPlayer != null) {
            return PlayerSkin.createVerified(this, PlayerSkin.SkinSource.FROM_PLAYER, fromPlayer);
        }
        String fromFile = this.getNullableString("skin_filename");
        if (fromFile != null) {
            return PlayerSkin.createVerified(this, PlayerSkin.SkinSource.FROM_FILE, fromFile);
        }
        String fromMineskin = this.getNullableString("mineskin_url");
        if (fromMineskin != null) {
            return PlayerSkin.createVerified(this, PlayerSkin.SkinSource.FROM_MINESKIN, fromMineskin);
        }
        return PlayerSkin.DEFAULT;
    }

    @Nullable
    public PlaybackModifiers getSimpleModifiers(CommandOutput commandOutput) {
        String playerName = this.getNullableString("player_name");
        if (!PlaybackModifiers.checkIfProperName(commandOutput, playerName)) {
            return null;
        }
        PlayerSkin playerSkin = this.getPlayerSkin();
        if (playerSkin == null) {
            return null;
        }
        PlayerAsEntity playerAsEntity = PlayerAsEntity.DISABLED;
        try {
            Tag tag;
            String playerAsEntityId = ResourceArgument.getEntityType(this.ctx, (String)"entity").key().location().toString();
            try {
                tag = NbtTagArgument.getNbtTag(this.ctx, (String)"nbt");
            }
            catch (Exception e) {
                tag = null;
            }
            CompoundTag nbt = tag instanceof CompoundTag ? (CompoundTag)tag : null;
            playerAsEntity = new PlayerAsEntity(playerAsEntityId, nbt != null ? nbt.toString() : null);
        }
        catch (Exception playerAsEntityId) {
            // empty catch block
        }
        PlaybackModifiers modifiers = PlaybackModifiers.empty();
        modifiers.playerName = playerName;
        modifiers.playerSkin = playerSkin;
        modifiers.playerAsEntity = playerAsEntity;
        return modifiers;
    }
}

