/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.events;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.mt1006.mocap.mocap.actions.Hurt;
import net.mt1006.mocap.mocap.playing.Playing;
import net.mt1006.mocap.mocap.recording.EntityTracker;
import net.mt1006.mocap.mocap.recording.Recording;

public class EntityEvent {
    public static void onEntityHurt(LivingEntity entity) {
        if (Recording.isActive() && entity.level() instanceof ServerLevel) {
            Recording.byRecordedPlayer((Entity)entity).forEach(ctx -> ctx.addAction(new Hurt()));
            Recording.listTrackedEntities((Entity)entity).forEach(EntityTracker.TrackedEntity::onHurt);
        }
    }

    public static boolean onEntityDrop(LivingEntity entity) {
        return !Playing.playbacks.isEmpty() && entity.getTags().contains("mocap_entity");
    }

    public static void onPlayerRespawn(ServerPlayer oldPlayer, ServerPlayer newPlayer) {
        if (!Recording.isActive() && !Recording.waitingForRespawn.isEmpty()) {
            Recording.waitingForRespawn.clear();
        }
        if (Recording.waitingForRespawn.isEmpty()) {
            return;
        }
        Recording.waitingForRespawn.byKey.get((Object)oldPlayer).forEach(ctx -> ctx.onRespawn(newPlayer));
        Recording.waitingForRespawn.byKey.removeAll((Object)oldPlayer);
    }
}

