/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.mt1006.mocap.mocap.actions.BreakBlock;
import net.mt1006.mocap.mocap.actions.BreakBlockProgress;
import net.mt1006.mocap.mocap.actions.ChangeItem;
import net.mt1006.mocap.mocap.actions.ChangePose;
import net.mt1006.mocap.mocap.actions.ChatMessage;
import net.mt1006.mocap.mocap.actions.ComparableAction;
import net.mt1006.mocap.mocap.actions.Die;
import net.mt1006.mocap.mocap.actions.EntityAction;
import net.mt1006.mocap.mocap.actions.EntityUpdate;
import net.mt1006.mocap.mocap.actions.Hurt;
import net.mt1006.mocap.mocap.actions.Movement;
import net.mt1006.mocap.mocap.actions.NextTick;
import net.mt1006.mocap.mocap.actions.PlaceBlock;
import net.mt1006.mocap.mocap.actions.PlaceBlockSilently;
import net.mt1006.mocap.mocap.actions.Respawn;
import net.mt1006.mocap.mocap.actions.RightClickBlock;
import net.mt1006.mocap.mocap.actions.SetArrowCount;
import net.mt1006.mocap.mocap.actions.SetEffectColor;
import net.mt1006.mocap.mocap.actions.SetEntityFlags;
import net.mt1006.mocap.mocap.actions.SetLivingEntityFlags;
import net.mt1006.mocap.mocap.actions.SetMainHand;
import net.mt1006.mocap.mocap.actions.SetSpectator;
import net.mt1006.mocap.mocap.actions.SkipTicks;
import net.mt1006.mocap.mocap.actions.Sleep;
import net.mt1006.mocap.mocap.actions.Swing;
import net.mt1006.mocap.mocap.actions.VehicleData;
import net.mt1006.mocap.mocap.actions.deprecated.HeadRotation;
import net.mt1006.mocap.mocap.actions.deprecated.MovementLegacy;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public interface Action {
    public static final List<FromReader> REGISTERED = new ArrayList<FromReader>();
    public static final MutableInt lastRegisteredId = new MutableInt(-1);

    default public void prepareWrite(RecordingData data) {
    }

    public void write(RecordingFiles.Writer var1);

    public Result execute(ActionContext var1);

    public static void init() {
        if (REGISTERED.isEmpty()) {
            for (Type type : Type.values()) {
                type.init();
            }
        }
    }

    public static Action readAction(RecordingFiles.Reader reader, RecordingData data) {
        FromReader constructor = REGISTERED.get(reader.readByte());
        return constructor != null ? (Action)constructor.apply(reader, data) : null;
    }

    public static enum Type {
        NEXT_TICK(0, NextTick::new),
        MOVEMENT_LEGACY(1, MovementLegacy::new),
        HEAD_ROTATION(2, HeadRotation::new),
        CHANGE_POSE(3, ChangePose::new, ChangePose::new),
        CHANGE_ITEM(4, ChangeItem::new, ChangeItem::new),
        SET_ENTITY_FLAGS(5, SetEntityFlags::new, SetEntityFlags::new),
        SET_LIVING_ENTITY_FLAGS(6, SetLivingEntityFlags::new, SetLivingEntityFlags::new),
        SET_MAIN_HAND(7, SetMainHand::new, SetMainHand::new),
        SWING(8, Swing::new, Swing::new),
        BREAK_BLOCK(9, BreakBlock::new),
        PLACE_BLOCK(10, PlaceBlock::new),
        RIGHT_CLICK_BLOCK(11, RightClickBlock::new),
        SET_EFFECT_COLOR(12, SetEffectColor::new, SetEffectColor::new),
        SET_ARROW_COUNT(13, SetArrowCount::new, SetArrowCount::new),
        SLEEP(14, Sleep::new, Sleep::new),
        PLACE_BLOCK_SILENTLY(15, PlaceBlockSilently::new),
        ENTITY_UPDATE(16, EntityUpdate::new),
        ENTITY_ACTION(17, EntityAction::new),
        HURT(18, Hurt::new),
        VEHICLE_DATA(19, VehicleData::new, VehicleData::new),
        BREAK_BLOCK_PROGRESS(20, BreakBlockProgress::new),
        MOVEMENT(21, Movement::new),
        SKIP_TICKS(22, SkipTicks::new),
        DIE(23, Die::new),
        RESPAWN(24, Respawn::new),
        CHAT_MESSAGE(25, ChatMessage::new),
        SET_SPECTATOR(26, SetSpectator::new, SetSpectator::new);

        public final byte id;
        public final FromReader fromReader;
        public final Function<Entity, ComparableAction> fromEntity;

        private Type(int id, FromReaderOnly onlyFromReader) {
            this(id, (reader, data) -> (Action)onlyFromReader.apply(reader));
        }

        private Type(@Nullable int id, FromReaderOnly onlyFromReader, FromEntity fromEntity) {
            this(id, (reader, data) -> (Action)onlyFromReader.apply(reader), fromEntity);
        }

        private Type(int id, FromReader fromReader) {
            this(id, fromReader, null);
            if (fromReader.apply(RecordingFiles.Reader.DUMMY, RecordingData.DUMMY) instanceof ComparableAction) {
                throw new RuntimeException("Tried to register ComparableAction without \"fromEntity\" constructor!");
            }
        }

        private Type(@Nullable int id, FromReader fromReader, FromEntity fromEntity) {
            this.id = (byte)id;
            this.fromReader = fromReader;
            this.fromEntity = fromEntity;
            if (id > 255) {
                throw new RuntimeException("Tried to register an Action with ID higher than 255!");
            }
            if (id != lastRegisteredId.getValue() + 1) {
                throw new RuntimeException("Tried to register an Action with id out of order!");
            }
            lastRegisteredId.setValue(id);
            if (fromEntity != null) {
                ComparableAction.REGISTERED.add(fromEntity);
            }
            REGISTERED.add(fromReader);
        }

        public void init() {
        }
    }

    public static interface FromReader
    extends BiFunction<RecordingFiles.Reader, RecordingData, Action> {
    }

    public static interface FromEntity
    extends Function<Entity, ComparableAction> {
    }

    public static interface FromReaderOnly
    extends Function<RecordingFiles.Reader, Action> {
    }

    public static enum Result {
        OK(false, false),
        IGNORED(false, false),
        NEXT_TICK(true, false),
        REPEAT(true, false),
        END(true, true),
        ERROR(true, true);

        public final boolean endsTick;
        public final boolean endsPlayback;

        private Result(boolean endsTick, boolean endsPlayback) {
            this.endsTick = endsTick;
            this.endsPlayback = endsPlayback;
        }
    }
}

