/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.BlockAction;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.mocap.playing.playback.PositionTransformer;
import net.mt1006.mocap.mocap.settings.Settings;

public class BreakBlock
implements BlockAction {
    private final BlockAction.BlockStateData previousBlockState;
    private final BlockPos blockPos;

    public BreakBlock(BlockState blockState, BlockPos blockPos) {
        this.previousBlockState = new BlockAction.BlockStateData(blockState);
        this.blockPos = blockPos;
    }

    public BreakBlock(RecordingFiles.Reader reader) {
        this.previousBlockState = new BlockAction.BlockStateData(reader);
        this.blockPos = reader.readBlockPos();
    }

    @Override
    public void prepareWrite(RecordingData data) {
        this.previousBlockState.prepareWrite(data);
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.BREAK_BLOCK.id);
        this.previousBlockState.write(writer);
        writer.addBlockPos(this.blockPos);
    }

    @Override
    public void preExecute(Entity entity, PositionTransformer transformer) {
        this.previousBlockState.placeSilently(entity, transformer, this.blockPos);
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        List<BlockPos> blocks = ctx.transformer.transformBlockPos(this.blockPos);
        blocks.forEach(b -> ctx.level.destroyBlock(b, ((Boolean)Settings.DROP_FROM_BLOCKS.val).booleanValue()));
        return Action.Result.OK;
    }
}

