/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.BlockAction;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.mocap.playing.playback.PositionTransformer;

public class BreakBlockProgress
implements BlockAction {
    private final BlockPos blockPos;
    private final int progress;

    public BreakBlockProgress(BlockPos blockPos, int progress) {
        this.blockPos = blockPos;
        this.progress = progress;
    }

    public BreakBlockProgress(RecordingFiles.Reader reader) {
        this.blockPos = reader.readBlockPos();
        this.progress = reader.readInt();
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.BREAK_BLOCK_PROGRESS.id);
        writer.addBlockPos(this.blockPos);
        writer.addInt(this.progress);
    }

    @Override
    public void preExecute(Entity entity, PositionTransformer transformer) {
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        List<BlockPos> blocks = ctx.transformer.transformBlockPos(this.blockPos);
        if (!blocks.isEmpty()) {
            ctx.level.destroyBlockProgress(ctx.entity.getId(), blocks.get(0), this.progress);
        }
        return Action.Result.OK;
    }
}

