/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.mixin.fields.LivingEntityFields;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.ComparableAction;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class ChangeItem
implements ComparableAction {
    private static final int ITEM_COUNT_LEGACY = 6;
    private static final int ITEM_COUNT = 7;
    private final byte itemCount;
    private final List<ItemData> items = new ArrayList<ItemData>();

    public ChangeItem(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            this.itemCount = 0;
            for (int i = 0; i < 7; ++i) {
                this.items.add(ItemData.EMPTY);
            }
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        this.addItem(livingEntity.getMainHandItem(), entity);
        this.addItem(livingEntity.getOffhandItem(), entity);
        this.addItem(livingEntity.getItemBySlot(EquipmentSlot.FEET), entity);
        this.addItem(livingEntity.getItemBySlot(EquipmentSlot.LEGS), entity);
        this.addItem(livingEntity.getItemBySlot(EquipmentSlot.CHEST), entity);
        this.addItem(livingEntity.getItemBySlot(EquipmentSlot.HEAD), entity);
        this.addItem(livingEntity.getItemBySlot(EquipmentSlot.BODY), entity);
        int itemCounter = 0;
        for (int i = 0; i < 7; ++i) {
            if (this.items.get((int)i).type == ItemDataType.NO_ITEM) continue;
            itemCounter = i + 1;
        }
        this.itemCount = (byte)itemCounter;
    }

    public ChangeItem(RecordingFiles.Reader reader) {
        byte firstByte = reader.readByte();
        if (firstByte >= 0) {
            reader.shift(-1);
            this.itemCount = (byte)6;
        } else {
            this.itemCount = firstByte != -128 ? -firstByte : (byte)0;
        }
        if (this.itemCount > 7) {
            int i;
            for (i = 0; i < 7; ++i) {
                this.items.add(new ItemData(reader));
            }
            for (i = 7; i < this.itemCount; ++i) {
                new ItemData(reader);
            }
        } else {
            int i;
            for (i = 0; i < this.itemCount; ++i) {
                this.items.add(new ItemData(reader));
            }
            for (i = this.itemCount; i < 7; ++i) {
                this.items.add(ItemData.EMPTY);
            }
        }
    }

    private void addItem(@Nullable ItemStack itemStack, Entity entity) {
        this.items.add(ItemData.get(itemStack, entity.registryAccess()));
    }

    private void setEntityItems(LivingEntity entity) {
        for (int i = 0; i < 7; ++i) {
            ItemData item = this.items.get(i);
            ItemStack itemStack = item.getItemStack(entity.registryAccess());
            switch (i) {
                case 0: {
                    entity.setItemSlot(EquipmentSlot.MAINHAND, itemStack);
                    break;
                }
                case 1: {
                    entity.setItemSlot(EquipmentSlot.OFFHAND, itemStack);
                    break;
                }
                case 2: {
                    entity.setItemSlot(EquipmentSlot.FEET, itemStack);
                    break;
                }
                case 3: {
                    entity.setItemSlot(EquipmentSlot.LEGS, itemStack);
                    break;
                }
                case 4: {
                    entity.setItemSlot(EquipmentSlot.CHEST, itemStack);
                    break;
                }
                case 5: {
                    entity.setItemSlot(EquipmentSlot.HEAD, itemStack);
                    break;
                }
                case 6: {
                    entity.setItemSlot(EquipmentSlot.BODY, itemStack);
                }
            }
            if (!(entity instanceof Player)) continue;
            ((LivingEntityFields)entity).callDetectEquipmentUpdates();
        }
    }

    @Override
    public boolean differs(ComparableAction previousAction) {
        if (this.items.size() != ((ChangeItem)previousAction).items.size()) {
            return true;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            ItemData item2;
            ItemData item1 = this.items.get(i);
            if (!item1.differs(item2 = ((ChangeItem)previousAction).items.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void prepareWrite(RecordingData data) {
        if (this.itemCount > this.items.size()) {
            throw new RuntimeException();
        }
        for (int i = 0; i < this.itemCount; ++i) {
            this.items.get(i).prepareWrite(data);
        }
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.CHANGE_ITEM.id);
        writer.addByte(this.itemCount > 0 ? (byte)(-this.itemCount) : (byte)-128);
        for (int i = 0; i < this.itemCount; ++i) {
            this.items.get(i).write(writer);
        }
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        if (this.items.size() != 7) {
            MocapMod.LOGGER.error("Item list size doesn't match proper item count!");
            return Action.Result.ERROR;
        }
        boolean isLivingEntity = ctx.entity instanceof LivingEntity;
        if (!isLivingEntity && ctx.ghostPlayer == null) {
            return Action.Result.IGNORED;
        }
        if (isLivingEntity) {
            this.setEntityItems((LivingEntity)ctx.entity);
        }
        if (ctx.ghostPlayer != null) {
            this.setEntityItems((LivingEntity)ctx.ghostPlayer);
        }
        return Action.Result.OK;
    }

    private static class ItemData {
        public static final ItemData EMPTY = new ItemData();
        public final ItemDataType type;
        public final Item item;
        public final String data;
        private int idToWrite = -1;

        private ItemData() {
            this.type = ItemDataType.NO_ITEM;
            this.item = Items.AIR;
            this.data = "";
        }

        private ItemData(ItemStack itemStack, RegistryAccess registryAccess) {
            this.item = itemStack.getItem();
            Tag tag = itemStack.save((HolderLookup.Provider)registryAccess);
            if (!(tag instanceof CompoundTag) || !((CompoundTag)tag).contains("components", 10)) {
                this.type = ItemDataType.ID_ONLY;
                this.data = "";
                return;
            }
            Tag componentsTag = ((CompoundTag)tag).get("components");
            if (!(componentsTag instanceof CompoundTag)) {
                this.type = ItemDataType.ID_ONLY;
                this.data = "";
                return;
            }
            this.type = ItemDataType.ID_AND_COMPONENTS;
            this.data = componentsTag.toString();
        }

        public ItemData(RecordingFiles.Reader reader) {
            this.type = ItemDataType.get(reader.readByte());
            int itemId = this.type.hasId ? reader.readInt() : 0;
            this.data = this.type.hasData ? reader.readString() : "";
            RecordingData recordingData = reader.getParent();
            if (recordingData == null) {
                this.item = Items.AIR;
                return;
            }
            this.item = recordingData.itemIdMap.getObject(itemId);
        }

        public static ItemData get(@Nullable ItemStack itemStack, RegistryAccess registryAccess) {
            return itemStack == null || itemStack.isEmpty() ? EMPTY : new ItemData(itemStack, registryAccess);
        }

        public boolean differs(ItemData itemData) {
            return this.type != itemData.type || this.item != itemData.item || !this.data.equals(itemData.data);
        }

        public void prepareWrite(RecordingData recordingData) {
            this.idToWrite = recordingData.itemIdMap.provideId(this.item);
        }

        public void write(RecordingFiles.Writer writer) {
            if (this.idToWrite == -1) {
                throw new RuntimeException("ItemData write wasn't prepared!");
            }
            writer.addByte(this.type.id);
            if (this.type.hasId) {
                writer.addInt(this.idToWrite);
            }
            if (this.type.hasData) {
                writer.addString(this.data);
            }
        }

        public ItemStack getItemStack(RegistryAccess registryAccess) {
            switch (this.type.ordinal()) {
                case 0: {
                    return ItemStack.EMPTY;
                }
                case 1: 
                case 2: {
                    return new ItemStack((ItemLike)this.item);
                }
                case 3: {
                    CompoundTag tag = this.tagFromIdAndComponents();
                    if (tag == null) {
                        return ItemStack.EMPTY;
                    }
                    return ItemStack.parse((HolderLookup.Provider)registryAccess, (Tag)tag).orElse(ItemStack.EMPTY);
                }
            }
            return null;
        }

        @Nullable
        private CompoundTag tagFromIdAndComponents() {
            CompoundTag tag = new CompoundTag();
            try {
                tag.put("components", (Tag)Utils.nbtFromString(this.data));
            }
            catch (CommandSyntaxException e) {
                return null;
            }
            tag.put("id", (Tag)StringTag.valueOf((String)BuiltInRegistries.ITEM.getKey((Object)this.item).toString()));
            tag.put("count", (Tag)IntTag.valueOf((int)1));
            return tag;
        }
    }

    private static enum ItemDataType {
        NO_ITEM(0, false, false),
        ID_ONLY(1, true, false),
        ID_AND_NBT(2, true, true),
        ID_AND_COMPONENTS(3, true, true);

        private static final ItemDataType[] VALUES;
        public final byte id;
        public final boolean hasId;
        public final boolean hasData;

        private ItemDataType(int id, boolean hasId, boolean hasData) {
            this.id = (byte)id;
            this.hasId = hasId;
            this.hasData = hasData;
        }

        public static ItemDataType get(byte id) {
            if (id < 0 || id >= VALUES.length) {
                return NO_ITEM;
            }
            ItemDataType type = VALUES[id];
            if (type.id != id) {
                throw new RuntimeException("ChangeItem.ItemDataType VALUES out of order!");
            }
            return type;
        }

        static {
            VALUES = ItemDataType.values();
        }
    }
}

