/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.EnumMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.ComparableAction;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;

public class ChangePose
implements ComparableAction {
    private static final BiMap<Integer, Pose> poseMap;
    private static final BiMap<Pose, Integer> poseIdMap;
    private final Pose pose;

    public ChangePose(Entity entity) {
        this.pose = entity.getPose();
    }

    public ChangePose(RecordingFiles.Reader reader) {
        this.pose = (Pose)poseMap.getOrDefault((Object)reader.readInt(), (Object)Pose.STANDING);
    }

    @Override
    public boolean differs(ComparableAction previousAction) {
        return this.pose != ((ChangePose)previousAction).pose;
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.CHANGE_POSE.id);
        writer.addInt((Integer)poseIdMap.getOrDefault((Object)this.pose, (Object)0));
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        ctx.entity.setPose(this.pose);
        return Action.Result.OK;
    }

    static {
        EnumMap<Pose, Integer> enumMap = new EnumMap<Pose, Integer>(Pose.class);
        enumMap.put(Pose.STANDING, 1);
        enumMap.put(Pose.FALL_FLYING, 2);
        enumMap.put(Pose.SLEEPING, 3);
        enumMap.put(Pose.SWIMMING, 4);
        enumMap.put(Pose.SPIN_ATTACK, 5);
        enumMap.put(Pose.CROUCHING, 6);
        enumMap.put(Pose.DYING, 7);
        enumMap.put(Pose.LONG_JUMPING, 8);
        enumMap.put(Pose.CROAKING, 9);
        enumMap.put(Pose.USING_TONGUE, 10);
        enumMap.put(Pose.SITTING, 11);
        enumMap.put(Pose.ROARING, 12);
        enumMap.put(Pose.SNIFFING, 13);
        enumMap.put(Pose.EMERGING, 14);
        enumMap.put(Pose.DIGGING, 15);
        enumMap.put(Pose.SLIDING, 16);
        enumMap.put(Pose.SHOOTING, 17);
        enumMap.put(Pose.INHALING, 18);
        poseIdMap = HashBiMap.create(enumMap);
        poseMap = poseIdMap.inverse();
    }
}

