/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.utils.FakePlayer;

public class ChatMessage
implements Action {
    private final String messageJson;

    public ChatMessage(String messageJson) {
        this.messageJson = messageJson;
    }

    public ChatMessage(RecordingFiles.Reader reader) {
        this.messageJson = reader.readString();
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.CHAT_MESSAGE.id);
        writer.addString(this.messageJson);
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        UUID senderUUID;
        FakePlayer player;
        if (!((Boolean)Settings.CHAT_PLAYBACK.val).booleanValue()) {
            return Action.Result.IGNORED;
        }
        FakePlayer fakePlayer = player = ctx.entity instanceof ServerPlayer ? (ServerPlayer)ctx.entity : ctx.ghostPlayer;
        if (player == null) {
            return Action.Result.IGNORED;
        }
        MinecraftServer server = ctx.level.getServer();
        MutableComponent message = Component.Serializer.fromJson((String)this.messageJson, (HolderLookup.Provider)server.registryAccess());
        if (message == null) {
            return Action.Result.IGNORED;
        }
        if (player == ctx.ghostPlayer) {
            List playerList = ctx.level.getServer().getPlayerList().getPlayers();
            if (playerList.isEmpty()) {
                return Action.Result.IGNORED;
            }
            senderUUID = ((ServerPlayer)playerList.get(0)).getUUID();
        } else {
            senderUUID = player.getUUID();
        }
        PlayerChatMessage chatMessage = PlayerChatMessage.unsigned((UUID)senderUUID, (String)message.getString()).withUnsignedContent((Component)message);
        server.getPlayerList().broadcastChatMessage(chatMessage, (ServerPlayer)player, ChatType.bind((ResourceKey)ChatType.CHAT, (Entity)player));
        return Action.Result.OK;
    }
}

