/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;

public class EntityAction
implements Action {
    private final int id;
    private final Action action;

    public EntityAction(int id, Action action) {
        this.id = id;
        this.action = action;
    }

    public EntityAction(RecordingFiles.Reader reader, RecordingData data) {
        this.id = reader.readInt();
        this.action = Action.readAction(reader, data);
    }

    @Override
    public void prepareWrite(RecordingData data) {
        this.action.prepareWrite(data);
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        RecordingFiles.Writer actionWriter = new RecordingFiles.Writer(writer.parent);
        this.action.write(actionWriter);
        if (actionWriter.getByteList().isEmpty()) {
            return;
        }
        writer.addByte(Action.Type.ENTITY_ACTION.id);
        writer.addInt(this.id);
        writer.addWriter(actionWriter);
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        if (!ctx.setContextEntity(this.id)) {
            return Action.Result.IGNORED;
        }
        Action.Result retVal = this.action.execute(ctx);
        ctx.setMainContextEntity();
        return retVal;
    }
}

