/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.mixin.fields.EntityIdFields;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.Hurt;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.modifiers.EntityFilter;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class EntityUpdate
implements Action {
    private final UpdateType type;
    private final int id;
    @Nullable
    private final String nbtString;
    @Nullable
    private final Vec3 position;

    public static EntityUpdate addEntity(int id, Entity entity) {
        String nbtString = EntityUpdate.serializeEntityNBT(entity).toString();
        return new EntityUpdate(UpdateType.ADD, id, nbtString, entity.position());
    }

    public static EntityUpdate removeEntity(int id) {
        return new EntityUpdate(UpdateType.REMOVE, id, null, null);
    }

    public static EntityUpdate kill(int id) {
        return new EntityUpdate(UpdateType.KILL, id, null, null);
    }

    public static EntityUpdate hurt(int id) {
        return new EntityUpdate(UpdateType.HURT, id, null, null);
    }

    public static EntityUpdate playerMount(int id) {
        return new EntityUpdate(UpdateType.PLAYER_MOUNT, id, null, null);
    }

    public static EntityUpdate playerDismount() {
        return new EntityUpdate(UpdateType.PLAYER_DISMOUNT, 0, null, null);
    }

    private EntityUpdate(UpdateType type, int id, @Nullable String nbtString, @Nullable Vec3 position) {
        this.type = type;
        this.id = id;
        this.nbtString = nbtString;
        this.position = position;
    }

    public EntityUpdate(RecordingFiles.Reader reader) {
        this.type = UpdateType.fromId(reader.readByte());
        this.id = reader.readInt();
        if (this.type == UpdateType.ADD) {
            this.nbtString = reader.readString();
            this.position = reader.readVec3();
        } else {
            this.nbtString = null;
            this.position = null;
        }
    }

    public static CompoundTag serializeEntityNBT(Entity entity) {
        CompoundTag compoundTag = new CompoundTag();
        String id = ((EntityIdFields)entity).callGetEncodeId();
        compoundTag.putString("id", id != null ? id : "minecraft:cow");
        entity.saveWithoutId(compoundTag);
        compoundTag.remove("UUID");
        compoundTag.remove("Pos");
        compoundTag.remove("Motion");
        return compoundTag;
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.ENTITY_UPDATE.id);
        writer.addByte(this.type.id);
        writer.addInt(this.id);
        if (this.type == UpdateType.ADD) {
            writer.addString(this.nbtString != null ? this.nbtString : "");
            if (this.position != null) {
                writer.addVec3(this.position);
            }
        }
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        switch (this.type.ordinal()) {
            case 1: {
                return this.executeAdd(ctx);
            }
            case 6: {
                ctx.entity.stopRiding();
                return Action.Result.OK;
            }
            case 0: {
                return Action.Result.IGNORED;
            }
        }
        ActionContext.EntityData entityData = ctx.entityDataMap.get(this.id);
        if (entityData == null) {
            return Action.Result.IGNORED;
        }
        Entity entity = entityData.entity;
        switch (this.type.ordinal()) {
            case 2: {
                entity.remove(Entity.RemovalReason.KILLED);
                return Action.Result.OK;
            }
            case 3: {
                entity.invulnerableTime = 0;
                entity.kill();
                return Action.Result.OK;
            }
            case 4: {
                Hurt.hurtEntity(entity);
                return Action.Result.OK;
            }
            case 5: {
                ctx.entity.startRiding(entity, true);
                return Action.Result.OK;
            }
        }
        return Action.Result.IGNORED;
    }

    private Action.Result executeAdd(ActionContext ctx) {
        CompoundTag nbt;
        EntityFilter filter = ctx.modifiers.entityFilter;
        if (this.nbtString == null || this.position == null || ctx.entityDataMap.containsKey(this.id) || filter.isEmpty()) {
            return Action.Result.IGNORED;
        }
        try {
            nbt = Utils.nbtFromString(this.nbtString);
        }
        catch (Exception e) {
            Utils.exception(e, "Exception occurred when parsing entity NBT data!");
            return Action.Result.ERROR;
        }
        Entity entity = EntityType.create((CompoundTag)nbt, (Level)ctx.level).orElse(null);
        if (entity == null || !filter.isAllowed(entity)) {
            return Action.Result.IGNORED;
        }
        entity.setPos(ctx.transformer.transformPos(this.position));
        entity.setDeltaMovement(0.0, 0.0, 0.0);
        entity.setNoGravity(true);
        entity.setInvulnerable(((Boolean)Settings.INVULNERABLE_PLAYBACK.val).booleanValue());
        entity.addTag("mocap_entity");
        if (entity instanceof Mob) {
            ((Mob)entity).setNoAi(true);
        }
        ctx.modifiers.transformations.scale.applyToEntity(entity);
        ctx.level.addFreshEntity(entity);
        ctx.entityDataMap.put(this.id, new ActionContext.EntityData(entity, this.position));
        return Action.Result.OK;
    }

    public static enum UpdateType {
        NONE(0),
        ADD(1),
        REMOVE(2),
        KILL(3),
        HURT(4),
        PLAYER_MOUNT(5),
        PLAYER_DISMOUNT(6);

        private static final UpdateType[] VALUES;
        private final byte id;

        private UpdateType(int id) {
            this.id = (byte)id;
        }

        private static UpdateType fromId(byte id) {
            for (UpdateType type : VALUES) {
                if (type.id != id) continue;
                return type;
            }
            return NONE;
        }

        static {
            VALUES = UpdateType.values();
        }
    }
}

