/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.mocap.settings.Settings;

public class Hurt
implements Action {
    public static final byte DUMMY = 0;

    public Hurt() {
    }

    public Hurt(RecordingFiles.Reader reader) {
        reader.readByte();
    }

    public static void hurtEntity(Entity entity) {
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        entity.setInvulnerable(false);
        if (livingEntity != null) {
            livingEntity.setHealth(livingEntity.getMaxHealth());
        }
        entity.invulnerableTime = 0;
        entity.hurt(new DamageSource(entity.level().damageSources().fellOutOfWorld().typeHolder()), 1.0f);
        if (livingEntity != null) {
            livingEntity.setHealth(livingEntity.getMaxHealth());
        }
        entity.setInvulnerable(((Boolean)Settings.INVULNERABLE_PLAYBACK.val).booleanValue());
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.HURT.id);
        writer.addByte((byte)0);
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        Hurt.hurtEntity(ctx.entity);
        return Action.Result.OK;
    }
}

