/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.mixin.fields.EntityFields;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import org.jetbrains.annotations.Nullable;

public class Movement
implements Action {
    private static final byte Y_0 = 0;
    private static final byte Y_SHORT = 1;
    private static final byte Y_FLOAT = 2;
    private static final byte Y_DOUBLE = 3;
    private static final byte XZ_0 = 0;
    private static final byte XZ_SHORT = 4;
    private static final byte XZ_FLOAT = 8;
    private static final byte XZ_DOUBLE = 12;
    private static final byte ROT_0 = 0;
    private static final byte ROT_HEAD_0 = 16;
    private static final byte ROT_HEAD_EQ = 32;
    private static final byte ROT_HEAD_DIFF = 48;
    private static final byte ON_GROUND = 64;
    private static final byte PACKED_Y = -128;
    private static final byte MASK_Y = 3;
    private static final byte MASK_XZ = 12;
    private static final byte MASK_ROT = 48;
    private static final double PACKED_Y_DIV = 4.0;
    private static final double PACKED_XZ_DIV = 2.0;
    private static final double MAX_ERROR = 2.0E-4;
    private final byte flags;
    private final Vec3 position;
    private final float[] rotation;
    private final float headRot;

    private Movement(byte flags, Vec3 position, float[] rotation, float headRot) {
        this.flags = flags;
        this.position = position;
        this.rotation = rotation;
        this.headRot = headRot;
    }

    public Movement(RecordingFiles.Reader reader) {
        this.flags = reader.readByte();
        double y = switch (this.flags & 3) {
            case 1 -> {
                if ((this.flags & 0xFFFFFF80) != 0) {
                    yield Movement.unpackValue(reader.readShort(), 4.0);
                }
                yield (double)reader.readShort() / 2.0;
            }
            case 2 -> reader.readFloat();
            case 3 -> reader.readDouble();
            default -> 0.0;
        };
        double x = this.readXZ(reader);
        double z = this.readXZ(reader);
        this.position = new Vec3(x, y, z);
        this.rotation = new float[2];
        if ((this.flags & 0x30) != 0) {
            this.rotation[0] = Movement.unpackRot(reader.readShort());
            this.rotation[1] = Movement.unpackRot(reader.readShort());
        }
        this.headRot = switch (this.flags & 0x30) {
            case 32 -> this.rotation[1];
            case 48 -> Movement.unpackRot(reader.readShort());
            default -> 0.0f;
        };
    }

    private double readXZ(RecordingFiles.Reader reader) {
        return switch (this.flags & 0xC) {
            case 4 -> Movement.unpackValue(reader.readShort(), 2.0);
            case 8 -> reader.readFloat();
            case 12 -> reader.readDouble();
            default -> 0.0;
        };
    }

    @Nullable
    public static Movement delta(double[] oldPos, Vec3 newPos, float[] oldRot, float newRotX, float newRotY, float oldHeadRot, float newHeadRot, boolean oldOnGround, boolean onGround, boolean forceNonPosData) {
        byte flags = onGround ? (byte)64 : 0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        float[] rotation = new float[2];
        float headRot = 0.0f;
        double newY = newPos.y;
        double oldY = oldPos[1];
        double deltaY = newY - oldY;
        if (Math.abs(deltaY) > 2.0E-4) {
            double newY2 = newY * 2.0;
            if (newY2 == (double)((short)newY2)) {
                flags = (byte)(flags | 1);
                y = newY;
            } else if (Movement.canBePacked(oldY, newY, 4.0)) {
                flags = (byte)(flags | 0xFFFFFF81);
                y = deltaY;
            } else if (Movement.canUseDeltaFloat(oldY, newY)) {
                flags = (byte)(flags | 2);
                y = deltaY;
            } else {
                flags = (byte)(flags | 3);
                y = newY;
            }
        }
        double oldX = oldPos[0];
        double newX = newPos.x;
        double oldZ = oldPos[2];
        double newZ = newPos.z;
        double deltaX = newX - oldX;
        double deltaZ = newZ - oldZ;
        if (Math.abs(deltaX) > 2.0E-4 || Math.abs(deltaZ) > 2.0E-4) {
            if (Movement.canBePacked(oldX, newX, 2.0) && Movement.canBePacked(oldZ, newZ, 2.0)) {
                flags = (byte)(flags | 4);
                x = deltaX;
                z = deltaZ;
            } else if (Movement.canUseDeltaFloat(oldX, newX) && Movement.canUseDeltaFloat(oldZ, newZ)) {
                flags = (byte)(flags | 8);
                x = deltaX;
                z = deltaZ;
            } else {
                flags = (byte)(flags | 0xC);
                x = newX;
                z = newZ;
            }
        }
        if (newRotX - oldRot[0] != 0.0f || newRotY - oldRot[1] != 0.0f || newHeadRot - oldHeadRot != 0.0f || forceNonPosData) {
            rotation[0] = newRotX;
            rotation[1] = newRotY;
            if (newHeadRot == 0.0f) {
                flags = (byte)(flags | 0x10);
                headRot = 0.0f;
            } else if (newHeadRot == newRotY) {
                flags = (byte)(flags | 0x20);
                headRot = newRotY;
            } else {
                flags = (byte)(flags | 0x30);
                headRot = newHeadRot;
            }
        }
        return (flags & 0xFFFFFFBF) != 0 || oldOnGround != onGround || forceNonPosData ? new Movement(flags, new Vec3(x, y, z), rotation, headRot) : null;
    }

    public static Movement teleportToPos(Vec3 pos, boolean onGround) {
        byte flags = (byte)((onGround ? 64 : 0) | 3 | 0xC | 0);
        float[] rotArray = new float[]{0.0f, 0.0f};
        return new Movement(flags, pos, rotArray, 0.0f);
    }

    private static boolean canUseDeltaFloat(double oldVal, double newVal) {
        return Math.abs(oldVal + (double)((float)(newVal - oldVal)) - newVal) <= 2.0E-4;
    }

    private static boolean canBePacked(double oldVal, double newVal, double div) {
        double delta = newVal - oldVal;
        return delta <= div && delta >= -div && Movement.marginOfError(oldVal, newVal, Movement.unpackValue(Movement.packValue(delta, div), div));
    }

    private static short packValue(double delta, double div) {
        return (short)(delta / div * 32767.0);
    }

    private static double unpackValue(short packed, double div) {
        return (double)packed / 32767.0 * div;
    }

    private static boolean marginOfError(double oldVal, double expected, double delta) {
        return Math.abs(oldVal + delta - expected) <= 2.0E-4;
    }

    private static short packRot(float rot) {
        return (short)((double)rot / 360.0 * 65536.0);
    }

    private static float unpackRot(short packed) {
        return (float)((double)packed / 65536.0 * 360.0);
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.MOVEMENT.id);
        writer.addByte(this.flags);
        switch (this.flags & 3) {
            case 1: {
                writer.addShort((this.flags & 0xFFFFFF80) != 0 ? Movement.packValue(this.position.y, 4.0) : (short)(this.position.y * 2.0));
                break;
            }
            case 2: {
                writer.addFloat((float)this.position.y);
                break;
            }
            case 3: {
                writer.addDouble(this.position.y);
            }
        }
        this.writeXZ(writer, this.position.x);
        this.writeXZ(writer, this.position.z);
        if ((this.flags & 0x30) != 0) {
            writer.addShort(Movement.packRot(this.rotation[0]));
            writer.addShort(Movement.packRot(this.rotation[1]));
        }
        if ((this.flags & 0x30) == 48) {
            writer.addShort(Movement.packRot(this.headRot));
        }
    }

    private void writeXZ(RecordingFiles.Writer writer, double val) {
        switch (this.flags & 0xC) {
            case 4: {
                writer.addShort(Movement.packValue(val, 2.0));
                break;
            }
            case 8: {
                writer.addFloat((float)val);
                break;
            }
            case 12: {
                writer.addDouble(val);
            }
        }
    }

    private boolean isYRelative() {
        int yFlags = this.flags & 3;
        boolean yShortAbs = yFlags == 1 && (this.flags & 0xFFFFFF80) == 0;
        return yFlags != 3 && !yShortAbs;
    }

    private boolean isXzRelative() {
        int xzFlags = this.flags & 0xC;
        return xzFlags != 12;
    }

    public void applyToPosition(double[] oldPos) {
        boolean xzRel = this.isXzRelative();
        boolean yRel = this.isYRelative();
        oldPos[0] = xzRel ? oldPos[0] + this.position.x : this.position.x;
        oldPos[1] = yRel ? oldPos[1] + this.position.y : this.position.y;
        oldPos[2] = xzRel ? oldPos[2] + this.position.z : this.position.z;
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        boolean updateRot = (this.flags & 0x30) != 0;
        float rotX = updateRot ? this.rotation[0] : ctx.entity.getXRot();
        float rotY = updateRot ? this.rotation[1] : ctx.entity.getYRot();
        float finHeadRot = ctx.transformer.transformRotation(this.headRot);
        ctx.changePosition(this.position, rotY, rotX, this.isXzRelative(), this.isYRelative(), updateRot);
        if (updateRot) {
            ctx.entity.setYHeadRot(finHeadRot);
        }
        ctx.entity.setOnGround((this.flags & 0x40) != 0);
        ((EntityFields)ctx.entity).callCheckInsideBlocks();
        ctx.fluentMovement(() -> new ClientboundTeleportEntityPacket(ctx.entity));
        if (updateRot) {
            byte headRotData = (byte)Math.floor(finHeadRot * 256.0f / 360.0f);
            ctx.fluentMovement(() -> new ClientboundRotateHeadPacket(ctx.entity, headRotData));
        }
        return Action.Result.OK;
    }

    public static class Statistics {
        public int count;
        public int y0;
        public int yAbsShort;
        public int yRelPacked;
        public int yRelFloat;
        public int yAbsDouble;
        public int xz0;
        public int xzRelPacked;
        public int xzRelFloat;
        public int xzAbsDouble;
        public int rot0;
        public int rotHead0;
        public int rotHeadEq;
        public int rotHeadDiff;
        public int onGroundFalse;
        public int onGroundTrue;
        public int errors;

        public void add(Movement movement) {
            boolean packedY;
            ++this.count;
            int yInfo = movement.flags & 3;
            int xzInfo = movement.flags & 0xC;
            int rotInfo = movement.flags & 0x30;
            boolean onGround = (movement.flags & 0x40) != 0;
            boolean bl = packedY = (movement.flags & 0xFFFFFF80) != 0;
            if (!packedY) {
                switch (yInfo) {
                    case 0: {
                        ++this.y0;
                        break;
                    }
                    case 1: {
                        ++this.yAbsShort;
                        break;
                    }
                    case 2: {
                        ++this.yRelFloat;
                        break;
                    }
                    case 3: {
                        ++this.yAbsDouble;
                        break;
                    }
                    default: {
                        ++this.errors;
                        break;
                    }
                }
            } else if (yInfo == 1) {
                ++this.yRelPacked;
            } else {
                ++this.errors;
            }
            switch (xzInfo) {
                case 0: {
                    ++this.xz0;
                    break;
                }
                case 4: {
                    ++this.xzRelPacked;
                    break;
                }
                case 8: {
                    ++this.xzRelFloat;
                    break;
                }
                case 12: {
                    ++this.xzAbsDouble;
                    break;
                }
                default: {
                    ++this.errors;
                }
            }
            switch (rotInfo) {
                case 0: {
                    ++this.rot0;
                    break;
                }
                case 16: {
                    ++this.rotHead0;
                    break;
                }
                case 32: {
                    ++this.rotHeadEq;
                    break;
                }
                case 48: {
                    ++this.rotHeadDiff;
                    break;
                }
                default: {
                    ++this.errors;
                }
            }
            if (onGround) {
                ++this.onGroundTrue;
            } else {
                ++this.onGroundFalse;
            }
        }
    }
}

