/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.BlockAction;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.mocap.playing.playback.PositionTransformer;

public class PlaceBlockSilently
implements BlockAction {
    private final BlockAction.BlockStateData previousBlockState;
    private final BlockAction.BlockStateData newBlockState;
    private final BlockPos blockPos;

    public PlaceBlockSilently(BlockState previousBlockState, BlockState newBlockState, BlockPos blockPos) {
        this.previousBlockState = new BlockAction.BlockStateData(previousBlockState);
        this.newBlockState = new BlockAction.BlockStateData(newBlockState);
        this.blockPos = blockPos;
    }

    public PlaceBlockSilently(RecordingFiles.Reader reader) {
        this.previousBlockState = new BlockAction.BlockStateData(reader);
        this.newBlockState = new BlockAction.BlockStateData(reader);
        this.blockPos = reader.readBlockPos();
    }

    @Override
    public void prepareWrite(RecordingData data) {
        this.previousBlockState.prepareWrite(data);
        this.newBlockState.prepareWrite(data);
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.PLACE_BLOCK_SILENTLY.id);
        this.previousBlockState.write(writer);
        this.newBlockState.write(writer);
        writer.addBlockPos(this.blockPos);
    }

    @Override
    public void preExecute(Entity entity, PositionTransformer transformer) {
        this.previousBlockState.placeSilently(entity, transformer, this.blockPos);
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        this.newBlockState.placeSilently(ctx.entity, ctx.transformer, this.blockPos);
        return Action.Result.OK;
    }
}

