/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import java.util.List;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.mt1006.mocap.mixin.fields.EntityFields;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.utils.FakePlayer;

public class Respawn
implements Action {
    public Respawn() {
    }

    public Respawn(RecordingFiles.Reader reader) {
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.RESPAWN.id);
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        ctx.entity.setPose(Pose.STANDING);
        if (ctx.entity instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)ctx.entity;
            entity.setHealth(entity.getMaxHealth());
            entity.deathTime = 0;
        }
        if (ctx.entity instanceof FakePlayer) {
            UUID uuid = ctx.entity.getUUID();
            ctx.broadcast((Packet<?>)new ClientboundPlayerInfoRemovePacket(List.of(uuid)));
            ctx.level.removePlayerImmediately((ServerPlayer)((FakePlayer)ctx.entity), Entity.RemovalReason.KILLED);
            ((FakePlayer)ctx.entity).fakeRespawn();
            ctx.level.getServer().getPlayerList().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, (ServerPlayer)((FakePlayer)ctx.entity)));
            ctx.level.addNewPlayer((ServerPlayer)((FakePlayer)ctx.entity));
        } else {
            ((EntityFields)ctx.entity).callUnsetRemoved();
            ctx.level.addFreshEntity(ctx.entity);
        }
        return Action.Result.OK;
    }
}

