/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.BlockAction;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.mocap.playing.playback.PositionTransformer;
import net.mt1006.mocap.utils.FakePlayer;

public class RightClickBlock
implements BlockAction {
    private final BlockHitResult blockHitResult;
    private final boolean offHand;

    public RightClickBlock(BlockHitResult blockHitResult, boolean offHand) {
        this.blockHitResult = blockHitResult;
        this.offHand = offHand;
    }

    public RightClickBlock(RecordingFiles.Reader reader) {
        Vec3 pos = reader.readVec3();
        BlockPos blockPos = reader.readBlockPos();
        Direction direction = this.directionFromByte(reader.readByte());
        boolean inside = reader.readBoolean();
        this.blockHitResult = new BlockHitResult(pos, direction, blockPos, inside);
        this.offHand = reader.readBoolean();
    }

    private Direction directionFromByte(byte val) {
        return switch (val) {
            case 1 -> Direction.UP;
            case 2 -> Direction.NORTH;
            case 3 -> Direction.SOUTH;
            case 4 -> Direction.WEST;
            case 5 -> Direction.EAST;
            default -> Direction.DOWN;
        };
    }

    private byte directionToByte(Direction direction) {
        return switch (direction) {
            case Direction.UP -> 1;
            case Direction.NORTH -> 2;
            case Direction.SOUTH -> 3;
            case Direction.WEST -> 4;
            case Direction.EAST -> 5;
            default -> 0;
        };
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.RIGHT_CLICK_BLOCK.id);
        writer.addVec3(this.blockHitResult.getLocation());
        writer.addBlockPos(this.blockHitResult.getBlockPos());
        writer.addByte(this.directionToByte(this.blockHitResult.getDirection()));
        writer.addBoolean(this.blockHitResult.isInside());
        writer.addBoolean(this.offHand);
    }

    @Override
    public void preExecute(Entity entity, PositionTransformer transformer) {
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        FakePlayer player;
        FakePlayer fakePlayer = player = ctx.entity instanceof Player ? (Player)ctx.entity : ctx.ghostPlayer;
        if (player == null) {
            return Action.Result.IGNORED;
        }
        InteractionHand interactionHand = this.offHand ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack itemStack = player.getItemInHand(interactionHand);
        for (BlockPos blockPos : ctx.transformer.transformBlockPos(this.blockHitResult.getBlockPos())) {
            ItemInteractionResult result;
            BlockState blockState = ctx.level.getBlockState(blockPos);
            if (blockState.getBlock() instanceof BedBlock || (result = blockState.useItemOn(itemStack, (Level)ctx.level, (Player)player, interactionHand, this.blockHitResult)) != ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) continue;
            blockState.useWithoutItem((Level)ctx.level, (Player)player, this.blockHitResult);
        }
        return Action.Result.OK;
    }
}

