/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.ComparableAction;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;

public class SetArrowCount
implements ComparableAction {
    private final int arrowCount;
    private final int beeStingerCount;

    public SetArrowCount(Entity entity) {
        if (entity instanceof LivingEntity) {
            this.arrowCount = ((LivingEntity)entity).getArrowCount();
            this.beeStingerCount = ((LivingEntity)entity).getStingerCount();
        } else {
            this.arrowCount = 0;
            this.beeStingerCount = 0;
        }
    }

    public SetArrowCount(RecordingFiles.Reader reader) {
        this.arrowCount = reader.readInt();
        this.beeStingerCount = reader.readInt();
    }

    @Override
    public boolean differs(ComparableAction previousAction) {
        return this.arrowCount != ((SetArrowCount)previousAction).arrowCount || this.beeStingerCount != ((SetArrowCount)previousAction).beeStingerCount;
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.SET_ARROW_COUNT.id);
        writer.addInt(this.arrowCount);
        writer.addInt(this.beeStingerCount);
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        if (!(ctx.entity instanceof LivingEntity)) {
            return Action.Result.IGNORED;
        }
        ((LivingEntity)ctx.entity).setArrowCount(this.arrowCount);
        ((LivingEntity)ctx.entity).setStingerCount(this.beeStingerCount);
        return Action.Result.OK;
    }
}

