/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import java.util.List;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.ComparableAction;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.utils.EntityData;

public class SetEffectColor
implements ComparableAction {
    private final int color;
    private final boolean ambience;

    public SetEffectColor(Entity entity) {
        if (entity instanceof LivingEntity) {
            int color = 0;
            for (ParticleOptions particle : EntityData.LIVING_ENTITY_EFFECT_PARTICLES.valOrDef(entity, List.of())) {
                if (!(particle instanceof ColorParticleOption) || particle.getType() != ParticleTypes.ENTITY_EFFECT) continue;
                ColorParticleOption colorParticle = (ColorParticleOption)particle;
                color = FastColor.ARGB32.colorFromFloat((float)colorParticle.getAlpha(), (float)colorParticle.getRed(), (float)colorParticle.getGreen(), (float)colorParticle.getBlue());
                break;
            }
            this.color = color;
            this.ambience = EntityData.LIVING_ENTITY_EFFECT_AMBIENCE.valOrDef(entity, false);
        } else {
            this.color = 0;
            this.ambience = false;
        }
    }

    public SetEffectColor(RecordingFiles.Reader reader) {
        this.color = reader.readInt();
        this.ambience = reader.readBoolean();
    }

    @Override
    public boolean differs(ComparableAction previousAction) {
        return this.color != ((SetEffectColor)previousAction).color || this.ambience != ((SetEffectColor)previousAction).ambience;
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.SET_EFFECT_COLOR.id);
        writer.addInt(this.color);
        writer.addBoolean(this.ambience);
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        if (!(ctx.entity instanceof LivingEntity)) {
            return Action.Result.IGNORED;
        }
        EntityData.LIVING_ENTITY_EFFECT_PARTICLES.set(ctx.entity, List.of(ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)this.color)));
        EntityData.LIVING_ENTITY_EFFECT_AMBIENCE.set(ctx.entity, this.ambience);
        return Action.Result.OK;
    }
}

