/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.world.entity.Entity;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.ComparableAction;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.utils.EntityData;

public class SetEntityFlags
implements ComparableAction {
    private final byte entityFlags;

    public SetEntityFlags(Entity entity) {
        this.entityFlags = EntityData.ENTITY_FLAGS.valOrDef(entity, (byte)0);
    }

    public SetEntityFlags(RecordingFiles.Reader reader) {
        this.entityFlags = reader.readByte();
    }

    @Override
    public boolean differs(ComparableAction previousAction) {
        return this.entityFlags != ((SetEntityFlags)previousAction).entityFlags;
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.SET_ENTITY_FLAGS.id);
        writer.addByte(this.entityFlags);
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        EntityData.ENTITY_FLAGS.set(ctx.entity, this.entityFlags);
        return Action.Result.OK;
    }
}

