/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.ComparableAction;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.utils.EntityData;

public class SetLivingEntityFlags
implements ComparableAction {
    private final byte livingEntityFlags;

    public SetLivingEntityFlags(Entity entity) {
        this.livingEntityFlags = entity instanceof LivingEntity ? EntityData.LIVING_ENTITY_FLAGS.valOrDef(entity, (byte)0) : (byte)0;
    }

    public SetLivingEntityFlags(RecordingFiles.Reader reader) {
        this.livingEntityFlags = reader.readByte();
    }

    @Override
    public boolean differs(ComparableAction previousAction) {
        return this.livingEntityFlags != ((SetLivingEntityFlags)previousAction).livingEntityFlags;
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.SET_LIVING_ENTITY_FLAGS.id);
        writer.addByte(this.livingEntityFlags);
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        if (!(ctx.entity instanceof LivingEntity)) {
            return Action.Result.IGNORED;
        }
        EntityData.LIVING_ENTITY_FLAGS.set(ctx.entity, this.livingEntityFlags);
        return Action.Result.OK;
    }
}

