/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.ComparableAction;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;

public class SetMainHand
implements ComparableAction {
    private final HumanoidArm mainHand;

    public SetMainHand(Entity entity) {
        this.mainHand = entity instanceof LivingEntity ? ((LivingEntity)entity).getMainArm() : HumanoidArm.RIGHT;
    }

    public SetMainHand(RecordingFiles.Reader reader) {
        this.mainHand = reader.readBoolean() ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
    }

    @Override
    public boolean differs(ComparableAction previousAction) {
        return this.mainHand != ((SetMainHand)previousAction).mainHand;
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.SET_MAIN_HAND.id);
        writer.addBoolean(this.mainHand == HumanoidArm.RIGHT);
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        if (ctx.entity instanceof Player) {
            ((Player)ctx.entity).setMainArm(this.mainHand);
        } else if (ctx.entity instanceof Mob) {
            ((Mob)ctx.entity).setLeftHanded(this.mainHand == HumanoidArm.LEFT);
        } else {
            return Action.Result.IGNORED;
        }
        return Action.Result.OK;
    }
}

