/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.ComparableAction;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.mocap.settings.Settings;

public class SetSpectator
implements ComparableAction {
    private final boolean isSpectator;

    public SetSpectator(Entity entity) {
        this.isSpectator = entity instanceof ServerPlayer && ((ServerPlayer)entity).gameMode.getGameModeForPlayer() == GameType.SPECTATOR;
    }

    public SetSpectator(RecordingFiles.Reader reader) {
        this.isSpectator = reader.readBoolean();
    }

    @Override
    public boolean differs(ComparableAction previousAction) {
        return this.isSpectator != ((SetSpectator)previousAction).isSpectator;
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.SET_SPECTATOR.id);
        writer.addBoolean(this.isSpectator);
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        if (!(ctx.entity instanceof ServerPlayer)) {
            return Action.Result.IGNORED;
        }
        ((ServerPlayer)ctx.entity).setGameMode(this.isSpectator ? GameType.SPECTATOR : ((Boolean)Settings.USE_CREATIVE_GAME_MODE.val != false ? GameType.CREATIVE : GameType.SURVIVAL));
        return Action.Result.OK;
    }
}

