/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.ComparableAction;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import org.jetbrains.annotations.Nullable;

public class Sleep
implements ComparableAction {
    @Nullable
    private final BlockPos bedPostion;

    public Sleep(Entity entity) {
        this.bedPostion = entity instanceof LivingEntity ? (BlockPos)((LivingEntity)entity).getSleepingPos().orElse(null) : null;
    }

    public Sleep(RecordingFiles.Reader reader) {
        this.bedPostion = reader.readBoolean() ? reader.readBlockPos() : null;
    }

    @Override
    public boolean differs(ComparableAction previousAction) {
        if (this.bedPostion == null && ((Sleep)previousAction).bedPostion == null) {
            return false;
        }
        if (this.bedPostion == null != (((Sleep)previousAction).bedPostion == null)) {
            return true;
        }
        return this.bedPostion != null && !this.bedPostion.equals((Object)((Sleep)previousAction).bedPostion);
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.SLEEP.id);
        if (this.bedPostion != null) {
            writer.addBoolean(true);
            writer.addBlockPos(this.bedPostion);
        } else {
            writer.addBoolean(false);
        }
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        if (!(ctx.entity instanceof LivingEntity)) {
            return Action.Result.IGNORED;
        }
        if (this.bedPostion != null) {
            ((LivingEntity)ctx.entity).setSleepingPos(this.bedPostion);
        } else {
            ((LivingEntity)ctx.entity).clearSleepingPos();
        }
        return Action.Result.OK;
    }
}

