/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.ComparableAction;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;

public class Swing
implements ComparableAction {
    private final boolean swinging;
    private final int swingingTime;
    private final InteractionHand hand;

    public Swing(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.swinging = livingEntity.swinging;
            this.swingingTime = livingEntity.swingTime;
            this.hand = livingEntity.swingingArm;
        } else {
            this.swinging = false;
            this.swingingTime = 0;
            this.hand = InteractionHand.MAIN_HAND;
        }
    }

    public Swing(RecordingFiles.Reader reader) {
        this.swinging = true;
        this.swingingTime = 0;
        this.hand = reader.readBoolean() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    @Override
    public boolean differs(ComparableAction previousAction) {
        Swing previousSwing = (Swing)previousAction;
        return this.swinging && (previousSwing == null || !previousSwing.swinging || previousSwing.swingingTime > this.swingingTime);
    }

    @Override
    public boolean shouldBeInitialized() {
        return false;
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.SWING.id);
        writer.addBoolean(this.hand == InteractionHand.OFF_HAND);
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        if (!(ctx.entity instanceof LivingEntity)) {
            return Action.Result.IGNORED;
        }
        ((LivingEntity)ctx.entity).swing(this.hand);
        return Action.Result.OK;
    }
}

