/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.mt1006.mocap.mixin.fields.AbstractHorseFields;
import net.mt1006.mocap.mixin.fields.BoatFields;
import net.mt1006.mocap.mixin.fields.HorseFields;
import net.mt1006.mocap.mixin.fields.PigFields;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.ComparableAction;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.utils.EntityData;

public class VehicleData
implements ComparableAction {
    private final boolean used;
    private byte flags = 0;
    private boolean flag1 = false;
    private boolean flag2 = false;
    private int int1 = 0;
    private int int2 = 0;
    private int int3 = 0;
    private float float1 = 0.0f;

    public VehicleData(Entity entity) {
        if (entity instanceof Player) {
            this.used = false;
            return;
        }
        if (entity instanceof AgeableMob) {
            boolean bl = this.flag2 = ((AgeableMob)entity).getAge() < 0;
        }
        if (entity instanceof AbstractHorse) {
            AbstractHorse abstractHorse = (AbstractHorse)entity;
            if (abstractHorse.isTamed()) {
                this.flags = (byte)(this.flags | 2);
            }
            if (abstractHorse.isSaddled()) {
                this.flags = (byte)(this.flags | 4);
            }
            if (abstractHorse.isBred()) {
                this.flags = (byte)(this.flags | 8);
            }
            if (abstractHorse.isStanding()) {
                this.flags = (byte)(this.flags | 0x20);
            }
            if ((EntityData.ABSTRACT_HORSE_FLAGS.valOrDef(entity, (byte)0) & 0x40) != 0) {
                this.flags = (byte)(this.flags | 0x40);
            }
            if (entity instanceof Horse) {
                this.int1 = ((HorseFields)entity).callGetTypeVariant();
            } else if (entity instanceof AbstractChestedHorse) {
                this.flag1 = ((AbstractChestedHorse)entity).hasChest();
            } else if (entity instanceof Camel) {
                this.flag1 = ((Camel)entity).isDashing();
            }
            if (entity instanceof Llama) {
                this.int1 = ((Llama)entity).getVariant().getId();
            }
        } else if (entity instanceof Pig) {
            this.flag1 = ((Pig)entity).isSaddled();
        } else if (entity instanceof Boat) {
            this.flag1 = ((Boat)entity).getPaddleState(0);
            this.flag2 = ((Boat)entity).getPaddleState(1);
            this.int1 = ((Boat)entity).getHurtTime();
            this.int2 = ((Boat)entity).getHurtDir();
            this.int3 = ((BoatFields)entity).callGetBubbleTime();
            this.float1 = ((Boat)entity).getDamage();
        } else if (entity instanceof AbstractMinecart) {
            this.int1 = ((AbstractMinecart)entity).getHurtTime();
            this.int2 = ((AbstractMinecart)entity).getHurtDir();
            this.float1 = ((AbstractMinecart)entity).getDamage();
        }
        this.used = true;
    }

    public VehicleData(RecordingFiles.Reader reader) {
        this.used = reader.readBoolean();
        if (this.used) {
            this.flags = reader.readByte();
            this.flag1 = reader.readBoolean();
            this.flag2 = reader.readBoolean();
            this.int1 = reader.readInt();
            this.int2 = reader.readInt();
            this.int3 = reader.readInt();
            this.float1 = reader.readFloat();
        }
    }

    @Override
    public boolean differs(ComparableAction previousAction) {
        VehicleData vehicleData = (VehicleData)previousAction;
        if (!this.used && !vehicleData.used) {
            return false;
        }
        if (this.used != vehicleData.used) {
            return true;
        }
        return this.flags != vehicleData.flags || this.flag1 != vehicleData.flag1 || this.flag2 != vehicleData.flag2 || this.int1 != vehicleData.int1 || this.int2 != vehicleData.int2 || this.int3 != vehicleData.int3 || this.float1 != vehicleData.float1;
    }

    @Override
    public void write(RecordingFiles.Writer writer) {
        writer.addByte(Action.Type.VEHICLE_DATA.id);
        writer.addBoolean(this.used);
        if (this.used) {
            writer.addByte(this.flags);
            writer.addBoolean(this.flag1);
            writer.addBoolean(this.flag2);
            writer.addInt(this.int1);
            writer.addInt(this.int2);
            writer.addInt(this.int3);
            writer.addFloat(this.float1);
        }
    }

    @Override
    public Action.Result execute(ActionContext ctx) {
        if (!this.used) {
            return Action.Result.OK;
        }
        if (ctx.entity instanceof AgeableMob) {
            ((AgeableMob)ctx.entity).setAge(this.flag2 ? -1 : 0);
        }
        if (ctx.entity instanceof AbstractHorse) {
            EntityData.ABSTRACT_HORSE_FLAGS.set(ctx.entity, this.flags);
            try {
                ItemStack itemStack = new ItemStack((ItemLike)((this.flags & 4) != 0 ? Items.SADDLE : Items.AIR));
                ((AbstractHorseFields)ctx.entity).getInventory().setItem(0, itemStack);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ctx.entity instanceof Horse) {
                ((HorseFields)ctx.entity).callSetTypeVariant(this.int1);
            } else if (ctx.entity instanceof AbstractChestedHorse) {
                ((AbstractChestedHorse)ctx.entity).setChest(this.flag1);
            } else if (ctx.entity instanceof Camel) {
                ((Camel)ctx.entity).setDashing(this.flag1);
            }
            if (ctx.entity instanceof Llama) {
                ((Llama)ctx.entity).setVariant(Llama.Variant.byId((int)this.int1));
            }
        } else if (ctx.entity instanceof Pig) {
            ((PigFields)ctx.entity).getSteering().setSaddle(this.flag1);
        } else if (ctx.entity instanceof Boat) {
            ((Boat)ctx.entity).setPaddleState(this.flag1, this.flag2);
            ((Boat)ctx.entity).setHurtTime(this.int1);
            ((Boat)ctx.entity).setHurtDir(this.int2);
            ((BoatFields)ctx.entity).callSetBubbleTime(this.int3);
            ((Boat)ctx.entity).setDamage(this.float1);
        } else if (ctx.entity instanceof AbstractMinecart) {
            ((AbstractMinecart)ctx.entity).setHurtTime(this.int1);
            ((AbstractMinecart)ctx.entity).setHurtDir(this.int2);
            ((AbstractMinecart)ctx.entity).setDamage(this.float1);
        }
        return Action.Result.OK;
    }
}

