/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.files;

import java.io.ByteArrayInputStream;
import java.util.Scanner;
import net.mt1006.mocap.command.io.CommandOutput;
import net.mt1006.mocap.mocap.files.SceneData;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;
import net.mt1006.mocap.mocap.playing.modifiers.PlayerAsEntity;
import net.mt1006.mocap.mocap.playing.modifiers.PlayerSkin;
import net.mt1006.mocap.mocap.playing.modifiers.StartDelay;
import net.mt1006.mocap.mocap.playing.modifiers.Transformations;
import org.jetbrains.annotations.Nullable;

public class LegacySceneDataParser {
    private static final String NULL_STR = "[null]";
    private boolean legacy = true;
    private boolean parsed = false;

    public LegacySceneDataParser(SceneData sceneData, CommandOutput commandOutput, byte[] scene) {
        try {
            Scanner scanner = new Scanner(new ByteArrayInputStream(scene));
            try {
                int versionNumber;
                try {
                    versionNumber = Integer.parseInt(scanner.next());
                }
                catch (NumberFormatException e) {
                    this.legacy = false;
                    scanner.close();
                    return;
                }
                if (!sceneData.setAndVerifyVersion(commandOutput, versionNumber)) {
                    scanner.close();
                }
                if (scanner.hasNextLine()) {
                    scanner.nextLine();
                }
                while (scanner.hasNextLine()) {
                    sceneData.subscenes.add(LegacySceneDataParser.parseSubscene(new Scanner(scanner.nextLine())));
                }
                this.parsed = true;
            }
            finally {
                try {
                    scanner.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (Exception e) {
            commandOutput.sendException(e, "error.failed_to_load_scene", new Object[0]);
        }
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public boolean wasParsed() {
        return this.parsed;
    }

    private static SceneData.Subscene parseSubscene(Scanner scanner) {
        SceneData.Subscene subscene = new SceneData.Subscene(scanner.next(), PlaybackModifiers.empty());
        try {
            subscene.modifiers.startDelay = StartDelay.fromSeconds(Double.parseDouble(scanner.next()));
            subscene.modifiers.transformations = Transformations.fromLegacyScene(Double.parseDouble(scanner.next()), Double.parseDouble(scanner.next()), Double.parseDouble(scanner.next()));
            subscene.modifiers.playerName = LegacySceneDataParser.parsePlayerName(scanner);
            subscene.modifiers.playerSkin = LegacySceneDataParser.parsePlayerSkin(scanner);
            String playerAsEntityStr = scanner.next();
            if (playerAsEntityStr.equals(NULL_STR)) {
                playerAsEntityStr = null;
            }
            subscene.modifiers.playerAsEntity = new PlayerAsEntity(playerAsEntityStr, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return subscene;
    }

    @Nullable
    private static String parsePlayerName(Scanner scanner) {
        try {
            String nameStr = scanner.next();
            return nameStr.length() <= 16 && !nameStr.equals(NULL_STR) ? nameStr : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static PlayerSkin parsePlayerSkin(Scanner scanner) {
        PlayerSkin.SkinSource skinSource = PlayerSkin.SkinSource.DEFAULT;
        String skinPath = NULL_STR;
        try {
            skinPath = scanner.next();
            if (!skinPath.equals(NULL_STR)) {
                skinSource = PlayerSkin.SkinSource.FROM_MINESKIN;
            }
            skinSource = PlayerSkin.SkinSource.fromID(Integer.parseInt(scanner.next()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new PlayerSkin(skinSource, skinPath.equals(NULL_STR) ? null : skinPath);
    }
}

