/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.files;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.command.io.CommandOutput;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.BlockAction;
import net.mt1006.mocap.mocap.actions.NextTick;
import net.mt1006.mocap.mocap.actions.SkipTicks;
import net.mt1006.mocap.mocap.files.Files;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.mocap.playing.playback.PositionTransformer;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.utils.EntityData;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class RecordingData {
    public static final RecordingData DUMMY = new RecordingData();
    private static final byte FLAGS1_ENDS_WITH_DEATH = 1;
    private static final byte FLAGS1_NULL_TERMINATED_STRINGS = 2;
    private static final byte FLAGS1_HAS_ID_MAPS = 4;
    private static final byte FLAGS1_START_DIMENSION_SPECIFIED = 8;
    private static final byte FLAGS1_PLAYER_NAME_SPECIFIED = 16;
    public long fileSize = 0L;
    public byte version = 0;
    public boolean experimentalVersion = false;
    public Vec3 startPos = Vec3.ZERO;
    public final float[] startRot = new float[2];
    public boolean endsWithDeath = false;
    private boolean usesIdMaps = true;
    public final ItemIdMap itemIdMap = new ItemIdMap(this);
    public final BlockStateIdMap blockStateIdMap = new BlockStateIdMap(this);
    @Nullable
    public String startDimension = null;
    @Nullable
    public String playerName = null;
    public final List<Action> actions = new ArrayList<Action>();
    public final List<BlockAction> blockActions = new ArrayList<BlockAction>();
    public long tickCount = 0L;

    public static RecordingData forWriting() {
        RecordingData data = new RecordingData();
        data.version = (byte)5;
        data.experimentalVersion = true;
        return data;
    }

    public void save(BufferedOutputStream stream) throws IOException {
        if (this.version != 5) {
            throw new RuntimeException("Trying to save recording with read-only version.");
        }
        this.actions.forEach(action -> action.prepareWrite(this));
        RecordingFiles.Writer writer = new RecordingFiles.Writer(this);
        writer.addByte(this.experimentalVersion ? -this.version : this.version);
        this.saveHeader(writer);
        this.actions.forEach(action -> action.write(writer));
        stream.write(writer.toByteArray());
    }

    public boolean load(CommandOutput commandOutput, String name) {
        byte[] data = Files.loadFile(Files.getRecordingFile(commandOutput, name));
        return data != null && this.load(commandOutput, new RecordingFiles.FileReader(this, data, true));
    }

    private boolean load(CommandOutput commandOutput, RecordingFiles.FileReader reader) {
        this.fileSize = reader.getSize();
        byte versionByte = reader.readByte();
        this.version = (byte)Math.abs(versionByte);
        boolean bl = this.experimentalVersion = versionByte < 0;
        if (this.version > 5) {
            commandOutput.sendFailure("playback.start.error.load_header", new Object[0]);
            return false;
        }
        this.loadHeader(reader, this.version <= 2);
        while (reader.canRead()) {
            Action action = Action.readAction(reader, this);
            if (action == null) {
                return false;
            }
            this.actions.add(action);
            if (action instanceof BlockAction) {
                this.blockActions.add((BlockAction)action);
                continue;
            }
            if (action instanceof NextTick) {
                ++this.tickCount;
                continue;
            }
            if (!(action instanceof SkipTicks)) continue;
            this.tickCount += (long)((SkipTicks)action).number;
        }
        return true;
    }

    private void saveHeader(RecordingFiles.Writer writer) {
        boolean hasIdMaps = this.usesIdMaps && (this.itemIdMap.size() != 0 || this.blockStateIdMap.size() != 0);
        writer.addVec3(this.startPos);
        writer.addFloat(this.startRot[0]);
        writer.addFloat(this.startRot[1]);
        byte flags1 = 0;
        flags1 = (byte)(flags1 | (this.endsWithDeath ? 1 : 0));
        flags1 = (byte)(flags1 | 2);
        flags1 = (byte)(flags1 | (hasIdMaps ? 4 : 0));
        flags1 = (byte)(flags1 | (this.startDimension != null ? 8 : 0));
        flags1 = (byte)(flags1 | (this.playerName != null ? 16 : 0));
        writer.addByte(flags1);
        if (hasIdMaps) {
            this.itemIdMap.save(writer);
            this.blockStateIdMap.save(writer);
        }
        if (this.startDimension != null) {
            writer.addString(this.startDimension);
        }
        if (this.playerName != null) {
            writer.addString(this.playerName);
        }
    }

    private void loadHeader(RecordingFiles.FileReader reader, boolean legacyHeader) {
        boolean playerNameSpecified;
        this.startPos = reader.readVec3();
        this.startRot[0] = reader.readFloat();
        this.startRot[1] = reader.readFloat();
        if (legacyHeader) {
            return;
        }
        byte flags1 = reader.readByte();
        this.endsWithDeath = (flags1 & 1) != 0;
        reader.setStringMode((flags1 & 2) == 0);
        this.usesIdMaps = (flags1 & 4) != 0;
        boolean startDimensionSpecified = (flags1 & 8) != 0;
        boolean bl = playerNameSpecified = (flags1 & 0x10) != 0;
        if (this.usesIdMaps) {
            this.itemIdMap.load(reader);
            this.blockStateIdMap.load(reader);
        }
        if (startDimensionSpecified) {
            this.startDimension = reader.readString();
        }
        if (playerNameSpecified) {
            this.playerName = reader.readString();
        }
    }

    public void initEntityPosition(Entity entity, PositionTransformer transformer) {
        float rotY = transformer.transformRotation(this.startRot[0]);
        entity.moveTo(transformer.transformPos(this.startPos), rotY, this.startRot[1]);
        entity.setYHeadRot(rotY);
    }

    public void preExecute(Entity entity, PositionTransformer transformer) {
        if (((Boolean)Settings.BLOCK_INITIALIZATION.val).booleanValue()) {
            for (int i = this.blockActions.size() - 1; i >= 0; --i) {
                this.blockActions.get(i).preExecute(entity, transformer);
            }
        }
    }

    public Action.Result executeNext(ActionContext ctx, int pos) {
        if (pos >= this.actions.size()) {
            return Action.Result.END;
        }
        if (pos == 0) {
            this.firstExecute(ctx.entity);
        }
        try {
            Action nextAction = this.actions.get(pos);
            if (!((Boolean)Settings.BLOCK_ACTIONS_PLAYBACK.val).booleanValue() && nextAction instanceof BlockAction) {
                return Action.Result.OK;
            }
            return nextAction.execute(ctx);
        }
        catch (Exception e) {
            Utils.exception(e, "Exception occurred while executing action!");
            return Action.Result.ERROR;
        }
    }

    private void firstExecute(Entity entity) {
        if (entity instanceof Player) {
            EntityData.PLAYER_SKIN_PARTS.set(entity, (byte)127);
        }
    }

    public static class ItemIdMap
    extends RefIdMap<Item> {
        public ItemIdMap(RecordingData parent) {
            super(parent);
        }

        @Override
        protected void init() {
            this.put(Items.AIR);
        }

        @Override
        public int provideId(Item item) {
            return this.parent.usesIdMaps ? this.provideMappedId(item) : Item.getId((Item)item);
        }

        @Override
        public Item getObject(int id) {
            return this.parent.usesIdMaps ? (Item)this.getMappedObject(id) : Item.byId((int)id);
        }

        @Override
        protected void save(RecordingFiles.Writer writer) {
            writer.addInt(this.size());
            this.idToRef.subList(1, this.idToRef.size()).forEach(item -> writer.addString(this.resLocToStr(BuiltInRegistries.ITEM.getKey(item))));
        }

        @Override
        protected void load(RecordingFiles.Reader reader) {
            int size = reader.readInt();
            for (int i = 1; i <= size; ++i) {
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)reader.readString()));
                this.refToId.put((Object)item, i);
                this.idToRef.add(item);
            }
        }
    }

    public static class BlockStateIdMap
    extends RefIdMap<BlockState> {
        public BlockStateIdMap(RecordingData parent) {
            super(parent);
        }

        @Override
        protected void init() {
            this.put(Blocks.AIR.defaultBlockState());
        }

        @Override
        public int provideId(BlockState blockState) {
            return this.parent.usesIdMaps ? this.provideMappedId(blockState) : Block.getId((BlockState)blockState);
        }

        @Override
        public BlockState getObject(int id) {
            return this.parent.usesIdMaps ? (BlockState)this.getMappedObject(id) : Block.stateById((int)id);
        }

        @Override
        protected void save(RecordingFiles.Writer writer) {
            ArrayList properties = new ArrayList();
            writer.addInt(this.size());
            for (BlockState blockState : this.idToRef.subList(1, this.idToRef.size())) {
                properties.clear();
                properties.addAll(blockState.getProperties());
                if (properties.size() > Short.MAX_VALUE) {
                    MocapMod.LOGGER.warn("BlockState properties count limit reached ({})!", (Object)properties.size());
                    properties.clear();
                }
                writer.addString(this.resLocToStr(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock())));
                writer.addShort((short)properties.size());
                for (Property property : properties) {
                    writer.addString(property.getName());
                    writer.addString(BlockStateIdMap.propertyValueToStr(blockState, property));
                }
            }
        }

        @Override
        protected void load(RecordingFiles.Reader reader) {
            int size = reader.readInt();
            for (int i = 1; i <= size; ++i) {
                Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)reader.readString()));
                StateDefinition stateDefinition = block.getStateDefinition();
                BlockState blockState = block.defaultBlockState();
                int propertyCount = reader.readShort();
                for (int j = 0; j < propertyCount; ++j) {
                    Property property = stateDefinition.getProperty(reader.readString());
                    blockState = BlockStateIdMap.updateBlockState(blockState, property, reader.readString());
                }
                this.refToId.put((Object)blockState, i);
                this.idToRef.add(blockState);
            }
        }

        private static <T extends Comparable<T>> String propertyValueToStr(BlockState blockState, Property<T> property) {
            return property.getName(blockState.getValue(property));
        }

        private static <T extends Comparable<T>> BlockState updateBlockState(BlockState blockState, @Nullable Property<T> property, String str) {
            if (property == null) {
                return blockState;
            }
            Optional value = property.getValue(str);
            return value.map(val -> (BlockState)blockState.setValue(property, val)).orElse(blockState);
        }
    }

    public static abstract class RefIdMap<T> {
        protected final RecordingData parent;
        protected final Reference2IntMap<T> refToId = new Reference2IntOpenHashMap();
        protected final List<T> idToRef = new ArrayList<T>();

        public RefIdMap(RecordingData parent) {
            this.parent = parent;
            this.init();
        }

        public int size() {
            return this.idToRef.size() - 1;
        }

        protected int provideMappedId(T ref) {
            int id = this.refToId.getOrDefault(ref, -1);
            return id != -1 ? id : this.put(ref);
        }

        protected T getMappedObject(int id) {
            return this.idToRef.get(id);
        }

        protected int put(T ref) {
            int pos = this.idToRef.size();
            this.idToRef.add(ref);
            this.refToId.put(ref, pos);
            return pos;
        }

        protected String resLocToStr(ResourceLocation resLoc) {
            return resLoc.getNamespace().equals("minecraft") ? resLoc.getPath() : resLoc.toString();
        }

        protected abstract void init();

        public abstract int provideId(T var1);

        public abstract T getObject(int var1);

        protected abstract void save(RecordingFiles.Writer var1);

        protected abstract void load(RecordingFiles.Reader var1);
    }
}

