/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.files;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.command.io.CommandOutput;
import net.mt1006.mocap.mocap.files.Files;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.utils.Utils;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public class RecordingFiles {
    public static final byte VERSION = 5;
    private static final int ALT_NAME_MAX_I = 128;

    public static boolean save(CommandOutput commandOutput, File recordingFile, String name, RecordingData data) {
        try {
            if (recordingFile.exists()) {
                commandOutput.sendFailure("recording.save.already_exists", new Object[0]);
                return false;
            }
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(recordingFile));
            data.save(stream);
            stream.close();
        }
        catch (IOException e) {
            commandOutput.sendException(e, "recording.save.error", new Object[0]);
            return false;
        }
        CommandSuggestions.inputSet.add(name);
        return true;
    }

    public static boolean copy(CommandOutput commandOutput, String srcName, String destName) {
        File srcFile = Files.getRecordingFile(commandOutput, srcName);
        if (srcFile == null) {
            return false;
        }
        File destFile = Files.getRecordingFile(commandOutput, destName);
        if (destFile == null) {
            return false;
        }
        try {
            FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            commandOutput.sendException(e, "recordings.copy.failed", new Object[0]);
            return false;
        }
        CommandSuggestions.inputSet.add(destName);
        commandOutput.sendSuccess("recordings.copy.success", new Object[0]);
        return true;
    }

    public static boolean rename(CommandOutput commandOutput, String oldName, String newName) {
        File oldFile = Files.getRecordingFile(commandOutput, oldName);
        if (oldFile == null) {
            return false;
        }
        File newFile = Files.getRecordingFile(commandOutput, newName);
        if (newFile == null) {
            return false;
        }
        if (!oldFile.renameTo(newFile)) {
            commandOutput.sendFailure("recordings.rename.failed", new Object[0]);
            return false;
        }
        CommandSuggestions.inputSet.remove(oldName);
        CommandSuggestions.inputSet.add(newName);
        commandOutput.sendSuccess("recordings.rename.success", new Object[0]);
        return true;
    }

    public static boolean remove(CommandOutput commandOutput, String name) {
        File recordingFile = Files.getRecordingFile(commandOutput, name);
        if (recordingFile == null) {
            return false;
        }
        if (!recordingFile.delete()) {
            commandOutput.sendFailure("recordings.remove.failed", new Object[0]);
            return false;
        }
        CommandSuggestions.inputSet.remove(name);
        commandOutput.sendSuccess("recordings.remove.success", new Object[0]);
        return true;
    }

    public static boolean info(CommandOutput commandOutput, String name) {
        RecordingData recording = new RecordingData();
        if (!recording.load(commandOutput, name) && recording.version <= 5) {
            commandOutput.sendFailure("recordings.info.failed", new Object[0]);
            return false;
        }
        commandOutput.sendSuccess("recordings.info.info", new Object[0]);
        commandOutput.sendSuccess("file.info.name", name);
        if (!Files.printVersionInfo(commandOutput, 5, recording.version, recording.experimentalVersion)) {
            return true;
        }
        commandOutput.sendSuccess("recordings.info.length", String.format("%.2f", (double)recording.tickCount / 20.0), recording.tickCount);
        commandOutput.sendSuccess("recordings.info.size", String.format("%.2f", (double)recording.fileSize / 1024.0), (long)recording.actions.size() - recording.tickCount);
        String xStr = String.format(Locale.US, "%.2f", recording.startPos.x);
        String yStr = String.format(Locale.US, "%.2f", recording.startPos.y);
        String zStr = String.format(Locale.US, "%.2f", recording.startPos.z);
        MutableComponent tpSuggestionComponent = Utils.getEventComponent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/tp @p %s %s %s", xStr, yStr, zStr), String.format("%s %s %s", xStr, yStr, zStr));
        tpSuggestionComponent.withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)));
        commandOutput.sendSuccess("recordings.info.start_pos", tpSuggestionComponent);
        if (recording.playerName != null) {
            commandOutput.sendSuccess("recordings.info.player_name_assigned.yes", recording.playerName);
        } else {
            commandOutput.sendSuccess("recordings.info.player_name_assigned.no", new Object[0]);
        }
        commandOutput.sendSuccess(recording.endsWithDeath ? "recordings.info.dies.yes" : "recordings.info.dies.no", new Object[0]);
        return true;
    }

    @Nullable
    public static List<String> list() {
        if (!Files.initialized) {
            return null;
        }
        String[] fileList = Files.recordingsDirectory.list(Files::isRecordingFile);
        if (fileList == null) {
            return null;
        }
        ArrayList<String> recordings = new ArrayList<String>(fileList.length);
        for (String filename : fileList) {
            recordings.add(filename.substring(0, filename.lastIndexOf(46)));
        }
        Collections.sort(recordings);
        return recordings;
    }

    @Nullable
    public static String findAlternativeName(String name) {
        char ch;
        int lastDigit;
        if (name.isEmpty()) {
            return null;
        }
        int firstDigit = name.length();
        int i = lastDigit = name.length() - 1;
        while (i >= 0 && (ch = name.charAt(i)) >= '0' && ch <= '9') {
            firstDigit = i--;
        }
        if (firstDigit > lastDigit) {
            return null;
        }
        String prefix = name.substring(0, firstDigit);
        int suffix = Integer.parseInt(name.substring(firstDigit, lastDigit + 1));
        for (int i2 = suffix + 1; i2 <= suffix + 128; ++i2) {
            String possibleName = String.format("%s%d", prefix, i2);
            if (CommandSuggestions.inputSet.contains(possibleName)) continue;
            return possibleName;
        }
        return null;
    }

    public static class DummyReader
    implements Reader {
        @Override
        public byte readByte() {
            return 0;
        }

        @Override
        public short readShort() {
            return 0;
        }

        @Override
        public int readInt() {
            return 0;
        }

        @Override
        public float readFloat() {
            return 0.0f;
        }

        @Override
        public double readDouble() {
            return 0.0;
        }

        @Override
        public boolean readBoolean() {
            return false;
        }

        @Override
        public String readString() {
            return "";
        }

        @Override
        public void shift(int val) {
        }

        @Override
        @Nullable
        public RecordingData getParent() {
            return null;
        }
    }

    public static class FileReader
    implements Reader {
        private final byte[] recording;
        private final RecordingData parent;
        private boolean legacyString;
        public int offset = 0;

        public FileReader(RecordingData parent, byte[] recording, boolean legacyString) {
            this.recording = recording;
            this.parent = parent;
            this.legacyString = legacyString;
        }

        @Override
        public byte readByte() {
            return this.recording[this.offset++];
        }

        @Override
        public short readShort() {
            short retVal = (short)((this.recording[this.offset] & 0xFF) << 8 | this.recording[this.offset + 1] & 0xFF);
            this.offset += 2;
            return retVal;
        }

        @Override
        public int readInt() {
            int retVal = (this.recording[this.offset] & 0xFF) << 24 | (this.recording[this.offset + 1] & 0xFF) << 16 | (this.recording[this.offset + 2] & 0xFF) << 8 | this.recording[this.offset + 3] & 0xFF;
            this.offset += 4;
            return retVal;
        }

        @Override
        public float readFloat() {
            float retVal = FileReader.byteArrayToFloat(Arrays.copyOfRange(this.recording, this.offset, this.offset + 4));
            this.offset += 4;
            return retVal;
        }

        @Override
        public double readDouble() {
            double retVal = FileReader.byteArrayToDouble(Arrays.copyOfRange(this.recording, this.offset, this.offset + 8));
            this.offset += 8;
            return retVal;
        }

        @Override
        public boolean readBoolean() {
            return this.recording[this.offset++] == 1;
        }

        @Override
        public String readString() {
            if (this.legacyString) {
                return this.readLegacyString();
            }
            int termPos = -1;
            for (int i = this.offset; i < this.recording.length; ++i) {
                if (this.recording[i] != 0) continue;
                termPos = i;
                break;
            }
            int len = termPos - this.offset;
            String str = new String(this.recording, this.offset, len, StandardCharsets.UTF_8);
            this.offset += len + 1;
            return str;
        }

        private String readLegacyString() {
            int len = this.readInt();
            String str = new String(this.recording, this.offset, len, StandardCharsets.UTF_8);
            this.offset += len;
            return str;
        }

        @Override
        public void shift(int val) {
            this.offset += val;
        }

        @Override
        public RecordingData getParent() {
            return this.parent;
        }

        public void setStringMode(boolean legacyString) {
            this.legacyString = legacyString;
        }

        public boolean canRead() {
            return this.recording.length > this.offset;
        }

        public int getSize() {
            return this.recording.length;
        }

        private static float byteArrayToFloat(byte[] bytes) {
            int bits = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
            return Float.intBitsToFloat(bits);
        }

        private static double byteArrayToDouble(byte[] bytes) {
            long bits = ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
            return Double.longBitsToDouble(bits);
        }
    }

    public static interface Reader {
        public static final Reader DUMMY = new DummyReader();

        public byte readByte();

        public short readShort();

        public int readInt();

        public float readFloat();

        public double readDouble();

        public boolean readBoolean();

        public String readString();

        public void shift(int var1);

        @Nullable
        public RecordingData getParent();

        default public Vec3 readVec3() {
            return new Vec3(this.readDouble(), this.readDouble(), this.readDouble());
        }

        default public BlockPos readBlockPos() {
            return new BlockPos(this.readInt(), this.readInt(), this.readInt());
        }
    }

    public static class Writer {
        private final List<Byte> recording = new ArrayList<Byte>();
        public final RecordingData parent;

        public Writer(RecordingData parent) {
            this.parent = parent;
        }

        public void addByte(byte val) {
            this.recording.add(val);
        }

        public void addShort(short val) {
            this.recording.add((byte)(val >> 8));
            this.recording.add((byte)val);
        }

        public void addInt(int val) {
            this.recording.add((byte)(val >> 24));
            this.recording.add((byte)(val >> 16));
            this.recording.add((byte)(val >> 8));
            this.recording.add((byte)val);
        }

        public void addFloat(float val) {
            for (byte b : Writer.floatToByteArray(val)) {
                this.recording.add(b);
            }
        }

        public void addDouble(double val) {
            for (byte b : Writer.doubleToByteArray(val)) {
                this.recording.add(b);
            }
        }

        public void addBoolean(boolean val) {
            this.recording.add(val ? (byte)1 : 0);
        }

        public void addString(String val) {
            byte[] bytes;
            for (byte b : bytes = val.getBytes(StandardCharsets.UTF_8)) {
                this.recording.add(b);
            }
            this.recording.add((byte)0);
        }

        public void addVec3(Vec3 vec) {
            this.addDouble(vec.x);
            this.addDouble(vec.y);
            this.addDouble(vec.z);
        }

        public void addBlockPos(BlockPos blockPos) {
            this.addInt(blockPos.getX());
            this.addInt(blockPos.getY());
            this.addInt(blockPos.getZ());
        }

        public void addWriter(Writer writer) {
            this.recording.addAll(writer.recording);
        }

        public List<Byte> getByteList() {
            return this.recording;
        }

        public byte[] toByteArray() {
            byte[] array = new byte[this.recording.size()];
            for (int i = 0; i < this.recording.size(); ++i) {
                array[i] = this.recording.get(i);
            }
            return array;
        }

        private static byte[] floatToByteArray(float val) {
            int bits = Float.floatToIntBits(val);
            return new byte[]{(byte)(bits >> 24), (byte)(bits >> 16), (byte)(bits >> 8), (byte)bits};
        }

        private static byte[] doubleToByteArray(double val) {
            long bits = Double.doubleToLongBits(val);
            return new byte[]{(byte)(bits >> 56), (byte)(bits >> 48), (byte)(bits >> 40), (byte)(bits >> 32), (byte)(bits >> 24), (byte)(bits >> 16), (byte)(bits >> 8), (byte)bits};
        }
    }
}

