/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.files;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.command.io.CommandOutput;
import net.mt1006.mocap.mocap.files.Files;
import net.mt1006.mocap.mocap.files.LegacySceneDataParser;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;
import net.mt1006.mocap.mocap.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class SceneData {
    public final List<Subscene> subscenes = new ArrayList<Subscene>();
    public int version = 0;
    public boolean experimentalVersion = false;
    public long fileSize = 0L;

    public static SceneData empty() {
        SceneData sceneData = new SceneData();
        sceneData.version = 4;
        sceneData.experimentalVersion = true;
        return sceneData;
    }

    public boolean save(CommandOutput commandOutput, File file, String sceneName, String onSuccess, String onError) {
        JsonObject json = new JsonObject();
        json.add("version", (JsonElement)new JsonPrimitive((Number)(this.experimentalVersion ? -this.version : this.version)));
        JsonArray subscenesArray = new JsonArray();
        this.subscenes.forEach(s -> subscenesArray.add((JsonElement)s.toJson()));
        json.add("subscenes", (JsonElement)subscenesArray);
        try {
            FileWriter writer = new FileWriter(file);
            GsonBuilder gsonBuilder = (Boolean)Settings.PRETTY_SCENE_FILES.val != false ? new GsonBuilder().setPrettyPrinting() : new GsonBuilder();
            gsonBuilder.create().toJson((JsonElement)json, (Appendable)writer);
            writer.close();
            this.saveToSceneElementCache(sceneName);
            commandOutput.sendSuccess(onSuccess, new Object[0]);
            return true;
        }
        catch (Exception e) {
            commandOutput.sendException(e, onError, new Object[0]);
            return false;
        }
    }

    public boolean load(CommandOutput commandOutput, String name) {
        return this.load(commandOutput, Files.getSceneFile(commandOutput, name));
    }

    public boolean load(CommandOutput commandOutput, File file) {
        byte[] data = Files.loadFile(file);
        return data != null && this.load(commandOutput, data);
    }

    private boolean load(CommandOutput commandOutput, byte[] scene) {
        this.fileSize = scene.length;
        LegacySceneDataParser legacyParser = new LegacySceneDataParser(this, commandOutput, scene);
        if (legacyParser.isLegacy()) {
            return legacyParser.wasParsed();
        }
        try {
            JsonElement jsonElement = new JsonParser().parse((Reader)new InputStreamReader(new ByteArrayInputStream(scene)));
            JsonObject json = jsonElement.getAsJsonObject();
            if (json == null) {
                throw new Exception("Scene file isn't a JSON object!");
            }
            JsonElement versionElement = json.get("version");
            if (versionElement == null) {
                throw new Exception("Scene version not specified!");
            }
            if (!this.setAndVerifyVersion(commandOutput, versionElement.getAsInt())) {
                return false;
            }
            JsonElement subsceneArrayElement = json.get("subscenes");
            if (subsceneArrayElement == null) {
                throw new Exception("Scene subscenes list not found!");
            }
            for (JsonElement subsceneElement : subsceneArrayElement.getAsJsonArray()) {
                JsonObject subsceneObject = subsceneElement.getAsJsonObject();
                if (subsceneObject == null) {
                    throw new Exception("Scene subscene isn't a JSON object!");
                }
                this.subscenes.add(new Subscene(subsceneObject));
            }
            return true;
        }
        catch (Exception e) {
            commandOutput.sendException(e, "error.failed_to_load_scene", new Object[0]);
            return false;
        }
    }

    public boolean setAndVerifyVersion(CommandOutput commandOutput, int versionNumber) {
        this.version = Math.abs(versionNumber);
        boolean bl = this.experimentalVersion = versionNumber < 0;
        if (this.version > 4) {
            commandOutput.sendFailure("error.failed_to_load_scene", new Object[0]);
            commandOutput.sendFailure("error.failed_to_load_scene.not_supported", new Object[0]);
            return false;
        }
        return true;
    }

    @Nullable
    public List<String> saveToSceneElementCache(String sceneName) {
        ArrayList<String> elements = new ArrayList<String>(this.subscenes.size());
        int id = 1;
        for (Subscene subscene : this.subscenes) {
            elements.add(String.format("%03d-%s", id, subscene.name));
            ++id;
        }
        CommandSuggestions.sceneElementCache.put(sceneName, elements);
        return elements;
    }

    @Nullable
    public static Subscene loadSubscene(CommandOutput commandOutput, @Nullable SceneData sceneData, Pair<Integer, @Nullable String> pair) {
        return SceneData.loadSubscene(commandOutput, sceneData, (Integer)pair.getFirst(), (String)pair.getSecond());
    }

    @Nullable
    public static Subscene loadSubscene(CommandOutput commandOutput, @Nullable SceneData sceneData, int pos, @Nullable String expectedName) {
        if (sceneData == null) {
            return null;
        }
        if (sceneData.subscenes.size() < pos || pos < 1) {
            commandOutput.sendFailureWithTip("scenes.failure.wrong_element_pos", new Object[0]);
            return null;
        }
        Subscene subscene = sceneData.subscenes.get(pos - 1);
        if (expectedName != null && !expectedName.equals(subscene.name)) {
            commandOutput.sendFailure("scenes.failure.wrong_subscene_name", new Object[0]);
            return null;
        }
        return subscene;
    }

    public static class Subscene {
        public String name;
        public PlaybackModifiers modifiers;

        public Subscene(String name, PlaybackModifiers modifiers) {
            this.name = name;
            this.modifiers = modifiers;
        }

        public Subscene(JsonObject json) throws Exception {
            JsonElement nameElement = json.get("name");
            if (nameElement == null) {
                throw new Exception("JSON \"name\" element not found!");
            }
            this.name = nameElement.getAsString();
            this.modifiers = new PlaybackModifiers(new SceneFiles.Reader(json));
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.add("name", (JsonElement)new JsonPrimitive(this.name));
            this.modifiers.save(new SceneFiles.Writer(json));
            return json;
        }

        public Subscene copy() {
            try {
                return new Subscene(this.toJson());
            }
            catch (Exception e) {
                throw new RuntimeException("Something went wrong when copying subscene!");
            }
        }
    }
}

