/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.files;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.command.io.CommandInfo;
import net.mt1006.mocap.command.io.CommandOutput;
import net.mt1006.mocap.mocap.files.Files;
import net.mt1006.mocap.mocap.files.SceneData;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public class SceneFiles {
    public static final int VERSION = 4;

    public static boolean add(CommandOutput commandOutput, String name) {
        File file = Files.getSceneFile(commandOutput, name);
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            commandOutput.sendFailure("scenes.add.already_exists", new Object[0]);
            return false;
        }
        SceneData sceneData = SceneData.empty();
        boolean success = sceneData.save(commandOutput, file, name, "scenes.add.success", "scenes.add.error");
        if (success) {
            CommandSuggestions.inputSet.add(SceneFiles.nameWithDot(name));
        }
        return success;
    }

    public static boolean copy(CommandOutput commandOutput, String srcName, String destName) {
        File srcFile = Files.getSceneFile(commandOutput, srcName);
        if (srcFile == null) {
            return false;
        }
        File destFile = Files.getSceneFile(commandOutput, destName);
        if (destFile == null) {
            return false;
        }
        try {
            FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            commandOutput.sendException(e, "scenes.copy.failed", new Object[0]);
            return false;
        }
        CommandSuggestions.inputSet.add(SceneFiles.nameWithDot(destName));
        List<String> elementCache = CommandSuggestions.sceneElementCache.get(SceneFiles.nameWithDot(srcName));
        if (elementCache != null) {
            CommandSuggestions.sceneElementCache.put(SceneFiles.nameWithDot(destName), new ArrayList<String>(elementCache));
        }
        commandOutput.sendSuccess("scenes.copy.success", new Object[0]);
        return true;
    }

    public static boolean rename(CommandOutput commandOutput, String oldName, String newName) {
        File oldFile = Files.getSceneFile(commandOutput, oldName);
        if (oldFile == null) {
            return false;
        }
        File newFile = Files.getSceneFile(commandOutput, newName);
        if (newFile == null) {
            return false;
        }
        if (!oldFile.renameTo(newFile)) {
            commandOutput.sendFailure("scenes.rename.failed", new Object[0]);
            return false;
        }
        CommandSuggestions.inputSet.remove(SceneFiles.nameWithDot(oldName));
        CommandSuggestions.inputSet.add(SceneFiles.nameWithDot(newName));
        List<String> elementCache = CommandSuggestions.sceneElementCache.get(SceneFiles.nameWithDot(oldName));
        if (elementCache != null) {
            CommandSuggestions.sceneElementCache.remove(SceneFiles.nameWithDot(oldName));
            CommandSuggestions.sceneElementCache.put(SceneFiles.nameWithDot(newName), elementCache);
        }
        commandOutput.sendSuccess("scenes.rename.success", new Object[0]);
        return true;
    }

    public static boolean remove(CommandOutput commandOutput, String name) {
        File sceneFile = Files.getSceneFile(commandOutput, name);
        if (sceneFile == null) {
            return false;
        }
        if (!sceneFile.delete()) {
            commandOutput.sendFailure("scenes.remove.failed", new Object[0]);
            return false;
        }
        CommandSuggestions.inputSet.remove(SceneFiles.nameWithDot(name));
        CommandSuggestions.sceneElementCache.remove(SceneFiles.nameWithDot(name));
        commandOutput.sendSuccess("scenes.remove.success", new Object[0]);
        return true;
    }

    public static boolean addElement(CommandOutput commandOutput, String name, SceneData.Subscene subscene) {
        File file = Files.getSceneFile(commandOutput, name);
        SceneData sceneData = SceneFiles.loadSceneData(commandOutput, file);
        if (sceneData == null) {
            return false;
        }
        sceneData.subscenes.add(subscene);
        return sceneData.save(commandOutput, file, name, "scenes.add_to.success", "scenes.add_to.error");
    }

    public static boolean removeElement(CommandOutput commandOutput, String name, String posStr) {
        Pair<Integer, String> posPair = CommandUtils.splitIdStr(posStr);
        int pos = (Integer)posPair.getFirst();
        String expectedName = (String)posPair.getSecond();
        File file = Files.getSceneFile(commandOutput, name);
        SceneData sceneData = SceneFiles.loadSceneData(commandOutput, file);
        SceneData.Subscene subscene = SceneData.loadSubscene(commandOutput, sceneData, pos, expectedName);
        if (subscene == null) {
            return false;
        }
        sceneData.subscenes.remove(pos - 1);
        return sceneData.save(commandOutput, file, name, "scenes.remove_from.success", "scenes.remove_from.error");
    }

    public static boolean modify(CommandInfo commandInfo, String name, int pos, @Nullable String expectedName) {
        File file = Files.getSceneFile(commandInfo, name);
        SceneData sceneData = SceneFiles.loadSceneData(commandInfo, file);
        SceneData.Subscene subscene = SceneData.loadSubscene(commandInfo, sceneData, pos, expectedName);
        if (subscene == null) {
            return false;
        }
        SceneData.Subscene newSubscene = SceneFiles.modifySubscene(commandInfo, subscene);
        if (newSubscene == null) {
            commandInfo.sendFailure("scenes.modify.error", new Object[0]);
            return false;
        }
        sceneData.subscenes.set(pos - 1, newSubscene);
        return sceneData.save(commandInfo, file, name, "scenes.modify.success", "scenes.modify.error");
    }

    @Nullable
    private static SceneData.Subscene modifySubscene(CommandInfo rootCommandInfo, SceneData.Subscene oldSubscene) {
        SceneData.Subscene subscene = oldSubscene.copy();
        CommandInfo commandInfo = rootCommandInfo.getFinalCommandInfo();
        if (commandInfo == null) {
            rootCommandInfo.sendFailure("error.unable_to_get_argument", new Object[0]);
            return null;
        }
        String propertyName = commandInfo.getNode(5);
        if (propertyName == null) {
            rootCommandInfo.sendFailure("error.unable_to_get_argument", new Object[0]);
            return null;
        }
        try {
            if (propertyName.equals("subscene_name")) {
                subscene.name = commandInfo.getString("new_name");
                return subscene;
            }
            if (!subscene.modifiers.modify(commandInfo, propertyName, 5)) {
                rootCommandInfo.sendFailure("error.generic", new Object[0]);
                return null;
            }
            return subscene;
        }
        catch (Exception e) {
            rootCommandInfo.sendException(e, "error.unable_to_get_argument", new Object[0]);
            return null;
        }
    }

    public static boolean elementInfo(CommandOutput commandOutput, String name, String posStr) {
        Pair<Integer, String> posPair = CommandUtils.splitIdStr(posStr);
        int pos = (Integer)posPair.getFirst();
        String expectedName = (String)posPair.getSecond();
        File file = Files.getSceneFile(commandOutput, name);
        SceneData sceneData = SceneFiles.loadSceneData(commandOutput, file);
        SceneData.Subscene subscene = SceneData.loadSubscene(commandOutput, sceneData, pos, expectedName);
        if (subscene == null) {
            return false;
        }
        commandOutput.sendSuccess("scenes.element_info.info", new Object[0]);
        commandOutput.sendSuccess("scenes.element_info.id", name, pos);
        commandOutput.sendSuccess("scenes.element_info.name", subscene.name);
        subscene.modifiers.list(commandOutput);
        return true;
    }

    public static boolean listElements(CommandOutput commandOutput, String name) {
        SceneData sceneData = SceneFiles.loadSceneData(commandOutput, Files.getSceneFile(commandOutput, name));
        if (sceneData == null) {
            return false;
        }
        commandOutput.sendSuccess("scenes.list_elements", new Object[0]);
        int i = 1;
        for (SceneData.Subscene element : sceneData.subscenes) {
            commandOutput.sendSuccessLiteral("[%d] %s <%.3f> (%s)", i++, element.name, element.modifiers.startDelay.seconds, element.modifiers.playerName);
        }
        commandOutput.sendSuccessLiteral("[id] name <start_delay> (player_name)", new Object[0]);
        return true;
    }

    public static boolean info(CommandOutput commandOutput, String name) {
        SceneData sceneData = new SceneData();
        if (!sceneData.load(commandOutput, name) && sceneData.version <= 4) {
            commandOutput.sendFailure("scenes.info.failed", new Object[0]);
            return false;
        }
        commandOutput.sendSuccess("scenes.info.info", new Object[0]);
        commandOutput.sendSuccess("file.info.name", name);
        if (!Files.printVersionInfo(commandOutput, 4, sceneData.version, sceneData.experimentalVersion)) {
            return true;
        }
        commandOutput.sendSuccess("scenes.info.size", String.format("%.2f", (double)sceneData.fileSize / 1024.0), sceneData.subscenes.size());
        return true;
    }

    @Nullable
    public static List<String> list() {
        if (!Files.initialized) {
            return null;
        }
        String[] fileList = Files.sceneDirectory.list(Files::isSceneFile);
        if (fileList == null) {
            return null;
        }
        ArrayList<String> scenes = new ArrayList<String>();
        for (String filename : fileList) {
            scenes.add("." + filename.substring(0, filename.lastIndexOf(46)));
        }
        Collections.sort(scenes);
        return scenes;
    }

    private static String nameWithDot(String name) {
        return name.charAt(0) == '.' ? name : "." + name;
    }

    @Nullable
    private static SceneData loadSceneData(CommandOutput commandOutput, @Nullable File file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            commandOutput.sendFailure("scenes.failure.file_not_exists", new Object[0]);
            return null;
        }
        SceneData sceneData = new SceneData();
        return sceneData.load(commandOutput, file) ? sceneData : null;
    }

    public record Reader(JsonObject json) {
        public double readDouble(String name, double def) {
            JsonElement element = this.json.get(name);
            return element != null ? element.getAsDouble() : def;
        }

        public boolean readBoolean(String name, boolean def) {
            JsonElement element = this.json.get(name);
            return element != null ? element.getAsBoolean() : def;
        }

        @Nullable
        public String readString(String name) {
            JsonElement element = this.json.get(name);
            return element != null ? element.getAsString() : null;
        }

        @Nullable
        public Reader readObject(String name) {
            JsonElement element = this.json.get(name);
            return element != null ? new Reader(element.getAsJsonObject()) : null;
        }

        @Nullable
        public Vec3 readVec3(String name) {
            JsonElement element = this.json.get(name);
            if (element == null) {
                return null;
            }
            JsonArray array = element.getAsJsonArray();
            return new Vec3(array.get(0).getAsDouble(), array.get(1).getAsDouble(), array.get(2).getAsDouble());
        }

        public <T extends Enum<T>> T readEnum(String name, T def) {
            JsonElement element = this.json.get(name);
            return element != null ? Enum.valueOf(def.getDeclaringClass(), element.getAsString().toUpperCase()) : def;
        }
    }

    public record Writer(JsonObject json) {
        public Writer() {
            this(new JsonObject());
        }

        public void addDouble(String name, double val, double def) {
            if (val != def) {
                this.json.add(name, (JsonElement)new JsonPrimitive((Number)val));
            }
        }

        public void addBoolean(String name, boolean val, boolean def) {
            if (val != def) {
                this.json.add(name, (JsonElement)new JsonPrimitive(Boolean.valueOf(val)));
            }
        }

        public void addString(String name, @Nullable String val) {
            if (val != null) {
                this.json.add(name, (JsonElement)new JsonPrimitive(val));
            }
        }

        public void addObject(String name, @Nullable Writer object) {
            if (object != null) {
                this.json.add(name, (JsonElement)object.json);
            }
        }

        public void addVec3(String name, @Nullable Vec3 vec) {
            if (vec != null) {
                JsonArray array = new JsonArray();
                array.add((JsonElement)new JsonPrimitive((Number)vec.x));
                array.add((JsonElement)new JsonPrimitive((Number)vec.y));
                array.add((JsonElement)new JsonPrimitive((Number)vec.z));
                this.json.add(name, (JsonElement)array);
            }
        }

        public <T extends Enum<T>> void addEnum(String name, T val, T def) {
            if (val != def) {
                this.json.add(name, (JsonElement)new JsonPrimitive(val.name().toLowerCase()));
            }
        }
    }
}

