/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.mt1006.mocap.command.io.CommandOutput;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.files.SceneData;
import org.jetbrains.annotations.Nullable;

public class DataManager {
    private final Map<String, RecordingData> recordingMap = new HashMap<String, RecordingData>();
    private final Map<String, SceneData> sceneMap = new HashMap<String, SceneData>();
    private final Stack<String> resourceStack = new Stack();
    public boolean knownError = false;

    public boolean load(CommandOutput commandOutput, String name) {
        if (name.charAt(0) == '.') {
            if (this.resourceStack.contains(name)) {
                commandOutput.sendFailure("playback.start.error.loop", new Object[0]);
                this.resourceStack.push(name);
                this.knownError = true;
                return false;
            }
            this.resourceStack.push(name);
            if (!this.loadResource(commandOutput, name)) {
                return false;
            }
            SceneData scene = this.getScene(name);
            if (scene == null) {
                return false;
            }
            for (SceneData.Subscene subscene : scene.subscenes) {
                if (this.load(commandOutput, subscene.name)) continue;
                return false;
            }
        } else {
            this.resourceStack.push(name);
            if (!this.loadResource(commandOutput, name)) {
                return false;
            }
        }
        this.resourceStack.pop();
        return true;
    }

    @Nullable
    public RecordingData getRecording(String name) {
        return this.recordingMap.get(name);
    }

    @Nullable
    public SceneData getScene(String name) {
        return this.sceneMap.get(name);
    }

    public String getResourcePath() {
        StringBuilder retStr = new StringBuilder();
        for (String str : this.resourceStack) {
            retStr.append("/");
            retStr.append(str);
        }
        return new String(retStr);
    }

    private boolean loadResource(CommandOutput commandOutput, String name) {
        if (name.charAt(0) == '.') {
            if (this.sceneMap.containsKey(name)) {
                return true;
            }
            SceneData sceneData = new SceneData();
            if (!sceneData.load(commandOutput, name)) {
                return false;
            }
            this.sceneMap.put(name, sceneData);
        } else {
            if (this.recordingMap.containsKey(name)) {
                return true;
            }
            RecordingData recording = new RecordingData();
            if (!recording.load(commandOutput, name)) {
                return false;
            }
            this.recordingMap.put(name, recording);
        }
        return true;
    }
}

