/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.modifiers;

import net.minecraft.world.entity.Entity;
import net.mt1006.mocap.mocap.playing.modifiers.EntityFilterInstance;
import org.jetbrains.annotations.Nullable;

public class EntityFilter {
    public static final EntityFilter FOR_RECORDING = new EntityFilter(null);
    public static final EntityFilter FOR_PLAYBACK = new EntityFilter(null);
    @Nullable
    private static EntityFilterInstance recordingSettingInstance;
    @Nullable
    private static EntityFilterInstance playbackSettingInstance;
    @Nullable
    private final EntityFilterInstance constantInstance;

    public EntityFilter(@Nullable EntityFilterInstance instance) {
        this.constantInstance = instance;
    }

    public static EntityFilter fromString(@Nullable String str) {
        return str != null ? new EntityFilter(EntityFilterInstance.create(str)) : FOR_PLAYBACK;
    }

    @Nullable
    public String save() {
        if (this == FOR_RECORDING) {
            throw new RuntimeException("Trying to save FOR_RECORDING EntityFilter!");
        }
        if (this == FOR_PLAYBACK) {
            return null;
        }
        if (this.constantInstance == null) {
            throw new RuntimeException("Trying to save constant instance, but constantInstance is null!");
        }
        return this.constantInstance.filterStr;
    }

    public boolean isAllowed(Entity entity) {
        EntityFilterInstance instance = this.getInstance();
        return instance != null && instance.isAllowed(entity);
    }

    public boolean isEmpty() {
        EntityFilterInstance instance = this.getInstance();
        return instance == null || instance.isEmpty();
    }

    public boolean isDefaultForPlayback() {
        return this == FOR_PLAYBACK;
    }

    @Nullable
    private EntityFilterInstance getInstance() {
        if (this == FOR_RECORDING) {
            return recordingSettingInstance;
        }
        if (this == FOR_PLAYBACK) {
            return playbackSettingInstance;
        }
        return this.constantInstance;
    }

    public static void onTrackEntitiesSet(String str) {
        recordingSettingInstance = EntityFilterInstance.create(str);
    }

    public static void onPlaybackEntitiesSet(String str) {
        playbackSettingInstance = EntityFilterInstance.create(str);
    }
}

