/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.modifiers;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.mt1006.mocap.command.io.CommandInfo;
import net.mt1006.mocap.command.io.CommandOutput;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.mocap.playing.modifiers.EntityFilter;
import net.mt1006.mocap.mocap.playing.modifiers.EntityFilterInstance;
import net.mt1006.mocap.mocap.playing.modifiers.PlayerAsEntity;
import net.mt1006.mocap.mocap.playing.modifiers.PlayerSkin;
import net.mt1006.mocap.mocap.playing.modifiers.StartDelay;
import net.mt1006.mocap.mocap.playing.modifiers.Transformations;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class PlaybackModifiers {
    @Nullable
    public String playerName;
    public PlayerSkin playerSkin;
    public Transformations transformations;
    public PlayerAsEntity playerAsEntity;
    public StartDelay startDelay;
    public EntityFilter entityFilter;

    private PlaybackModifiers(@Nullable String playerName, PlayerSkin playerSkin, Transformations transformations, PlayerAsEntity playerAsEntity, StartDelay startDelay, EntityFilter entityFilter) {
        this.playerName = playerName;
        this.playerSkin = playerSkin;
        this.transformations = transformations;
        this.playerAsEntity = playerAsEntity;
        this.startDelay = startDelay;
        this.entityFilter = entityFilter;
    }

    public PlaybackModifiers(SceneFiles.Reader reader) {
        this.playerName = reader.readString("player_name");
        this.playerSkin = new PlayerSkin(reader.readObject("player_skin"));
        this.transformations = Transformations.fromObject(reader.readObject("transformations"));
        this.playerAsEntity = new PlayerAsEntity(reader.readObject("player_as_entity"));
        this.startDelay = StartDelay.fromSeconds(reader.readDouble("start_delay", 0.0));
        this.entityFilter = EntityFilter.fromString(reader.readString("entity_filter"));
    }

    public static PlaybackModifiers empty() {
        return new PlaybackModifiers(null, PlayerSkin.DEFAULT, Transformations.empty(), PlayerAsEntity.DISABLED, StartDelay.ZERO, EntityFilter.FOR_PLAYBACK);
    }

    public PlaybackModifiers mergeWithParent(PlaybackModifiers parent) {
        return new PlaybackModifiers(this.playerName != null ? this.playerName : parent.playerName, this.playerSkin.mergeWithParent(parent.playerSkin), this.transformations.mergeWithParent(parent.transformations), this.playerAsEntity.isEnabled() ? this.playerAsEntity : parent.playerAsEntity, this.startDelay, !this.entityFilter.isDefaultForPlayback() ? this.entityFilter : parent.entityFilter);
    }

    public PlaybackModifiers copy() {
        return new PlaybackModifiers(this.playerName, this.playerSkin, this.transformations.copy(), this.playerAsEntity, this.startDelay, this.entityFilter);
    }

    public boolean areDefault() {
        return this.playerName == null && this.playerSkin.skinSource == PlayerSkin.SkinSource.DEFAULT && this.transformations.areDefault() && !this.playerAsEntity.isEnabled() && this.startDelay == StartDelay.ZERO && this.entityFilter.isDefaultForPlayback();
    }

    public void save(SceneFiles.Writer writer) {
        writer.addString("player_name", this.playerName);
        writer.addObject("player_skin", this.playerSkin.save());
        writer.addObject("transformations", this.transformations.save());
        writer.addObject("player_as_entity", this.playerAsEntity.save());
        writer.addDouble("start_delay", this.startDelay.seconds, 0.0);
        writer.addString("entity_filter", this.entityFilter.save());
    }

    public void list(CommandOutput commandOutput) {
        if (this.playerName == null) {
            commandOutput.sendSuccess("scenes.element_info.player_name.default", new Object[0]);
        } else {
            commandOutput.sendSuccess("scenes.element_info.player_name.custom", this.playerName);
        }
        switch (this.playerSkin.skinSource) {
            case DEFAULT: {
                commandOutput.sendSuccess("scenes.element_info.skin.default", new Object[0]);
                break;
            }
            case FROM_PLAYER: {
                commandOutput.sendSuccess("scenes.element_info.skin.profile", this.playerSkin.skinPath);
                break;
            }
            case FROM_FILE: {
                commandOutput.sendSuccess("scenes.element_info.skin.file", this.playerSkin.skinPath);
                break;
            }
            case FROM_MINESKIN: {
                commandOutput.sendSuccess("scenes.element_info.skin.mineskin", new Object[0]);
                MutableComponent urlComponent = Utils.getEventComponent(ClickEvent.Action.OPEN_URL, this.playerSkin.skinPath, String.format("  (\u00a7n%s\u00a7r)", this.playerSkin.skinPath));
                commandOutput.sendSuccessComponent((Component)urlComponent);
            }
        }
        this.transformations.list(commandOutput);
        commandOutput.sendSuccess("scenes.element_info.start_delay", this.startDelay.seconds, this.startDelay.ticks);
        if (!this.playerAsEntity.isEnabled()) {
            commandOutput.sendSuccess("scenes.element_info.player_as_entity.disabled", new Object[0]);
        } else {
            commandOutput.sendSuccess("scenes.element_info.player_as_entity.enabled", this.playerAsEntity.entityId);
        }
        if (this.entityFilter.isDefaultForPlayback()) {
            commandOutput.sendSuccess("scenes.element_info.entity_filter.disabled", new Object[0]);
        } else {
            commandOutput.sendSuccess("scenes.element_info.entity_filter.enabled", this.entityFilter.save());
        }
    }

    public boolean modify(CommandInfo commandInfo, String propertyName, int propertyNodePosition) throws CommandSyntaxException {
        switch (propertyName) {
            case "start_delay": {
                this.startDelay = StartDelay.fromSeconds(commandInfo.getDouble("delay"));
                return true;
            }
            case "transformations": {
                String transformationType = commandInfo.getNode(propertyNodePosition + 1);
                if (transformationType == null) break;
                return this.transformations.modify(commandInfo, transformationType, propertyNodePosition + 1);
            }
            case "player_name": {
                this.playerName = commandInfo.getString("player_name");
                return true;
            }
            case "player_skin": {
                PlayerSkin newPlayerSkin = commandInfo.getPlayerSkin();
                if (newPlayerSkin == null) {
                    return false;
                }
                this.playerSkin = newPlayerSkin;
                return true;
            }
            case "player_as_entity": {
                String playerAsEntityMode = commandInfo.getNode(propertyNodePosition + 1);
                if (playerAsEntityMode == null) break;
                if (playerAsEntityMode.equals("enabled")) {
                    Tag tag;
                    String playerAsEntityId = ResourceArgument.getEntityType(commandInfo.ctx, (String)"entity").key().location().toString();
                    try {
                        tag = NbtTagArgument.getNbtTag(commandInfo.ctx, (String)"nbt");
                    }
                    catch (Exception e) {
                        tag = null;
                    }
                    CompoundTag nbt = tag instanceof CompoundTag ? (CompoundTag)tag : null;
                    this.playerAsEntity = new PlayerAsEntity(playerAsEntityId, nbt != null ? nbt.toString() : null);
                    return true;
                }
                if (!playerAsEntityMode.equals("disabled")) break;
                this.playerAsEntity = PlayerAsEntity.DISABLED;
                return true;
            }
            case "entity_filter": {
                String filterMode = commandInfo.getNode(propertyNodePosition + 1);
                if (filterMode == null) break;
                if (filterMode.equals("enabled")) {
                    String filterStr = commandInfo.getString("entity_filter");
                    EntityFilterInstance filterInstance = EntityFilterInstance.create(filterStr);
                    if (filterInstance == null) {
                        commandInfo.sendFailure("failure.entity_filter.failed_to_parse", new Object[0]);
                        return false;
                    }
                    this.entityFilter = new EntityFilter(filterInstance);
                    return true;
                }
                if (!filterMode.equals("disabled")) break;
                this.entityFilter = EntityFilter.FOR_PLAYBACK;
                return true;
            }
        }
        return false;
    }

    public static boolean checkIfProperName(CommandOutput commandOutput, @Nullable String name) {
        if (name == null) {
            return true;
        }
        if (name.length() > 16) {
            commandOutput.sendFailure("failure.improper_player_name", new Object[0]);
            commandOutput.sendFailure("failure.improper_player_name.too_long", new Object[0]);
            return false;
        }
        if (name.contains(" ")) {
            commandOutput.sendFailure("failure.improper_player_name", new Object[0]);
            commandOutput.sendFailure("failure.improper_player_name.contains_spaces", new Object[0]);
            return false;
        }
        return true;
    }
}

