/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.modifiers;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class PlayerAsEntity {
    public static final PlayerAsEntity DISABLED = new PlayerAsEntity(null, null);
    @Nullable
    public final String entityId;
    @Nullable
    public final String entityNbt;
    @Nullable
    private final EntityType<?> entityType;
    @Nullable
    private final CompoundTag compoundTag;

    public PlayerAsEntity(@Nullable String entityId, @Nullable String entityNbt) {
        this.entityId = entityId;
        this.entityNbt = entityNbt;
        this.entityType = PlayerAsEntity.prepareEntityType(entityId, entityNbt);
        this.compoundTag = PlayerAsEntity.prepareCompoundTag(entityId, entityNbt);
    }

    public PlayerAsEntity(@Nullable SceneFiles.Reader reader) {
        if (reader == null) {
            this.entityId = null;
            this.entityNbt = null;
            this.entityType = null;
            this.compoundTag = null;
            return;
        }
        this.entityId = reader.readString("id");
        this.entityNbt = reader.readString("nbt");
        this.entityType = PlayerAsEntity.prepareEntityType(this.entityId, this.entityNbt);
        this.compoundTag = PlayerAsEntity.prepareCompoundTag(this.entityId, this.entityNbt);
    }

    @Nullable
    public SceneFiles.Writer save() {
        if (!this.isEnabled()) {
            return null;
        }
        SceneFiles.Writer writer = new SceneFiles.Writer();
        writer.addString("id", this.entityId);
        writer.addString("nbt", this.entityNbt);
        return writer;
    }

    public boolean isEnabled() {
        return this.entityId != null;
    }

    @Nullable
    public Entity createEntity(Level level) {
        if (this.entityType == null && this.compoundTag == null) {
            return null;
        }
        return this.compoundTag != null ? (Entity)EntityType.create((CompoundTag)this.compoundTag, (Level)level).orElse(null) : this.entityType.create(level);
    }

    @Nullable
    private static EntityType<?> prepareEntityType(@Nullable String entityId, @Nullable String entityNbt) {
        if (entityId == null || entityNbt != null) {
            return null;
        }
        ResourceLocation entityRes = ResourceLocation.parse((String)entityId);
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityRes);
        return BuiltInRegistries.ENTITY_TYPE.containsKey(entityRes) ? entityType : null;
    }

    @Nullable
    private static CompoundTag prepareCompoundTag(@Nullable String entityId, @Nullable String entityNbt) {
        if (entityId == null || entityNbt == null) {
            return null;
        }
        try {
            CompoundTag nbt = Utils.nbtFromString(entityNbt);
            nbt.putString("id", entityId);
            return nbt;
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }
}

