/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.modifiers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import net.mt1006.mocap.command.io.CommandInfo;
import net.mt1006.mocap.command.io.CommandOutput;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.utils.Fields;
import net.mt1006.mocap.utils.ProfileUtils;
import org.jetbrains.annotations.Nullable;

public class PlayerSkin {
    public static final PlayerSkin DEFAULT = new PlayerSkin(SkinSource.DEFAULT, null);
    private static final String MINESKIN_URL_PREFIX1 = "minesk.in/";
    private static final String MINESKIN_URL_PREFIX2 = "mineskin.org/skins/";
    private static final String MINESKIN_API_URL = "https://api.mineskin.org/get/uuid/";
    public final SkinSource skinSource;
    @Nullable
    public final String skinPath;

    public PlayerSkin(SkinSource skinSource, @Nullable String skinPath) {
        this.skinSource = skinSource;
        this.skinPath = skinPath;
    }

    public PlayerSkin(@Nullable SceneFiles.Reader reader) {
        if (reader == null) {
            this.skinSource = SkinSource.DEFAULT;
            this.skinPath = null;
            return;
        }
        this.skinSource = SkinSource.fromName(reader.readString("skin_source"));
        this.skinPath = reader.readString("skin_path");
    }

    @Nullable
    public static PlayerSkin createVerified(CommandOutput commandOutput, SkinSource skinSource, @Nullable String skinPath) {
        if (skinSource == SkinSource.FROM_MINESKIN && skinPath != null && !PlayerSkin.verifyMineskinUrl(skinPath)) {
            commandOutput.sendFailure("failure.improper_mineskin_link", new Object[0]);
            return null;
        }
        return new PlayerSkin(skinSource, skinPath);
    }

    private static boolean verifyMineskinUrl(String url) {
        if (url.startsWith("https://")) {
            url = url.substring(8);
        } else if (url.startsWith("http://")) {
            url = url.substring(7);
        }
        return url.startsWith(MINESKIN_URL_PREFIX1) || url.startsWith(MINESKIN_URL_PREFIX2);
    }

    @Nullable
    public SceneFiles.Writer save() {
        if (this.skinSource == SkinSource.DEFAULT) {
            return null;
        }
        SceneFiles.Writer writer = new SceneFiles.Writer();
        writer.addString("skin_source", this.skinSource.getName());
        writer.addString("skin_path", this.skinPath);
        return writer;
    }

    public void addSkinToPropertyMap(CommandInfo commandInfo, PropertyMap propertyMap) throws IllegalArgumentException, IllegalAccessException {
        if (this.skinPath == null) {
            return;
        }
        switch (this.skinSource.ordinal()) {
            case 1: {
                GameProfile tempProfile = ProfileUtils.getGameProfile(commandInfo.server, this.skinPath);
                PropertyMap tempPropertyMap = (PropertyMap)Fields.gameProfileProperties.get(tempProfile);
                if (!tempPropertyMap.containsKey((Object)"textures")) {
                    commandInfo.sendFailure("playback.start.warning.skin.profile", new Object[0]);
                    break;
                }
                if (propertyMap.containsKey((Object)"textures")) {
                    propertyMap.get((Object)"textures").clear();
                }
                propertyMap.putAll((Object)"textures", (Iterable)tempPropertyMap.get((Object)"textures"));
                break;
            }
            case 2: {
                propertyMap.put((Object)"mocap:skin_from_file", (Object)new Property("mocap:skin_from_file", this.skinPath));
                break;
            }
            case 3: {
                if (!((Boolean)Settings.ALLOW_MINESKIN_REQUESTS.val).booleanValue()) {
                    return;
                }
                Property skinProperty = this.propertyFromMineskinURL(this.skinPath);
                if (skinProperty == null) {
                    commandInfo.sendFailure("playback.start.warning.skin.mineskin", new Object[0]);
                    break;
                }
                if (propertyMap.containsKey((Object)"textures")) {
                    propertyMap.get((Object)"textures").clear();
                }
                propertyMap.put((Object)"textures", (Object)skinProperty);
            }
        }
    }

    public PlayerSkin mergeWithParent(PlayerSkin parent) {
        return this.skinSource != SkinSource.DEFAULT ? new PlayerSkin(this.skinSource, this.skinPath) : new PlayerSkin(parent.skinSource, parent.skinPath);
    }

    @Nullable
    private Property propertyFromMineskinURL(String mineskinURL) {
        String mineskinID = mineskinURL.contains("/") ? mineskinURL.substring(mineskinURL.lastIndexOf(47) + 1) : mineskinURL;
        String mineskinApiURL = MINESKIN_API_URL + mineskinID;
        try {
            URL url = new URI(mineskinApiURL).toURL();
            URLConnection connection = url.openConnection();
            if (!(connection instanceof HttpsURLConnection)) {
                return null;
            }
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            httpsConnection.setUseCaches(false);
            httpsConnection.setRequestMethod("GET");
            Scanner scanner = new Scanner(httpsConnection.getInputStream());
            String text = scanner.useDelimiter("\\A").next();
            scanner.close();
            httpsConnection.disconnect();
            String value = text.split("\"value\":\"")[1].split("\"")[0];
            String signature = text.split("\"signature\":\"")[1].split("\"")[0];
            return new Property("textures", value, signature);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static enum SkinSource {
        DEFAULT(0),
        FROM_PLAYER(1),
        FROM_FILE(2),
        FROM_MINESKIN(3);

        private static final SkinSource[] VALUES;
        public final int id;

        private SkinSource(int id) {
            this.id = id;
        }

        public static SkinSource fromID(int id) {
            for (SkinSource s : VALUES) {
                if (s.id != id) continue;
                return s;
            }
            return DEFAULT;
        }

        public String getName() {
            return this.name().toLowerCase();
        }

        public static SkinSource fromName(@Nullable String name) {
            if (name == null) {
                return DEFAULT;
            }
            try {
                return SkinSource.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return DEFAULT;
            }
        }

        static {
            VALUES = SkinSource.values();
        }
    }
}

