/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.modifiers;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.mocap.files.SceneFiles;
import org.jetbrains.annotations.Nullable;

public class Scale {
    public static final Scale NORMAL = new Scale(1.0, 1.0);
    @Nullable
    private static final ResourceLocation SCALE_ID = BuiltInRegistries.ATTRIBUTE.getKey((Object)((Attribute)Attributes.SCALE.value()));
    public final double playerScale;
    public final double sceneScale;
    public final double totalSceneScale;

    private Scale(double playerScale, double sceneScale, double totalSceneScale) {
        this.playerScale = playerScale;
        this.sceneScale = sceneScale;
        this.totalSceneScale = totalSceneScale;
    }

    private Scale(double playerScale, double sceneScale) {
        this(playerScale, sceneScale, sceneScale);
    }

    public static Scale fromObject(@Nullable SceneFiles.Reader reader) {
        return reader != null ? new Scale(reader.readDouble("player_scale", 1.0), reader.readDouble("scene_scale", 1.0)) : NORMAL;
    }

    public Scale ofPlayer(double scale) {
        return new Scale(scale, this.sceneScale);
    }

    public Scale ofScene(double scale) {
        return new Scale(this.playerScale, scale);
    }

    @Nullable
    public SceneFiles.Writer save() {
        if (this.isNormal()) {
            return null;
        }
        SceneFiles.Writer writer = new SceneFiles.Writer();
        writer.addDouble("player_scale", this.playerScale, 1.0);
        writer.addDouble("scene_scale", this.sceneScale, 1.0);
        return writer;
    }

    public boolean isNormal() {
        return this.playerScale == 1.0 && this.sceneScale == 1.0;
    }

    public Scale mergeWithParent(Scale parent) {
        return new Scale(this.playerScale * parent.playerScale, this.sceneScale, this.totalSceneScale * parent.totalSceneScale);
    }

    public boolean canScaleInt(Vec3 startPos) {
        if (this.sceneScale == 1.0) {
            return true;
        }
        if (this.sceneScale != (double)((int)this.sceneScale)) {
            return false;
        }
        Vec3 vec = (int)this.sceneScale % 2 == 0 ? startPos : startPos.add(0.5, 0.0, 0.5);
        return vec.x == (double)((int)vec.x) && vec.y == (double)((int)vec.y) && vec.z == (double)((int)vec.z);
    }

    public void applyToPlayer(Entity player) {
        this.applyToEntity(player, this.playerScale * this.totalSceneScale);
    }

    public void applyToEntity(Entity entity) {
        this.applyToEntity(entity, this.totalSceneScale);
    }

    private void applyToEntity(Entity entity, double scale) {
        if (scale == 1.0 || !(entity instanceof LivingEntity) || SCALE_ID == null) {
            return;
        }
        AttributeModifier modifier = new AttributeModifier(SCALE_ID, scale - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        AttributeInstance instance = ((LivingEntity)entity).getAttributes().getInstance(Attributes.SCALE);
        if (instance != null) {
            instance.addPermanentModifier(modifier);
        }
    }

    public Vec3 applyToPoint(Vec3 point, Vec3 center) {
        if (this.sceneScale == 1.0) {
            return point;
        }
        return new Vec3((point.x - center.x) * this.sceneScale + center.x, (point.y - center.y) * this.sceneScale + center.y, (point.z - center.z) * this.sceneScale + center.z);
    }
}

